/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar.item;

import java.util.HashMap;
import org.eclipse.scada.configuration.lib.Properties;
import org.eclipse.scada.configuration.world.PropertyEntry;
import org.eclipse.scada.configuration.world.lib.oscar.Helper;
import org.eclipse.scada.configuration.world.lib.oscar.MasterHandlerPriorities;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.lib.oscar.item.ItemGenerator;
import org.eclipse.scada.configuration.world.lib.oscar.item.Items;
import org.eclipse.scada.configuration.world.osgi.CodeFragment;
import org.eclipse.scada.configuration.world.osgi.FormulaItem;
import org.eclipse.scada.configuration.world.osgi.FormulaItemInbound;
import org.eclipse.scada.configuration.world.osgi.FormulaItemOutbound;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.TypedItemReference;
import org.eclipse.scada.core.VariantType;

public class FormulaItemGenerator
extends ItemGenerator {
    private final FormulaItem item;

    public FormulaItemGenerator(FormulaItem item, OscarContext ctx, MasterHandlerPriorities priorities) {
        super((Item)item, ctx, priorities);
        this.item = item;
    }

    @Override
    public void generate() {
        super.generate();
        this.addFormulaSource();
    }

    @Override
    protected String makeSourceId() {
        return this.makeId("formula");
    }

    private void addFormulaSource() {
        HashMap<String, String> data = new HashMap<String, String>();
        String id = this.makeSourceId();
        Helper.addOptional(data, "engine", this.item.getScriptEngine());
        if (this.item.getInbound() != null) {
            FormulaItemInbound inbound = this.item.getInbound();
            data.put("inputFormula", inbound.getInputFormula());
            for (TypedItemReference input : inbound.getInputs()) {
                if (input.getItem() == null) {
                    throw new IllegalArgumentException(String.format("Input variable '%s' references to no item", input.getName()));
                }
                data.put("datasource." + input.getName(), Items.makeMasterId(input.getItem()));
                VariantType type = Helper.convert(input.getType());
                if (type == null) continue;
                data.put("datasourceType." + input.getName(), type.name());
            }
        }
        if (this.item.getOutbound() != null) {
            FormulaItemOutbound outbound = this.item.getOutbound();
            data.put("outputFormula", outbound.getOutputFormula());
            Helper.addOptional(data, "writeValueName", outbound.getWriteValueVariableName());
            data.put("outputDatasource.id", Items.makeMasterId(outbound.getOutput().getItem()));
            VariantType type = Helper.convert(outbound.getOutput().getType());
            if (type != null) {
                data.put("outputDatasource.type", type.name());
            }
        }
        int i = 0;
        for (CodeFragment init : this.item.getInitScripts()) {
            data.put("init." + i, init.getCode());
            ++i;
        }
        for (PropertyEntry entry : this.item.getInitProperties()) {
            if (Properties.isEmpty((PropertyEntry)entry)) continue;
            data.put("initProperty." + entry.getKey(), entry.getValue());
        }
        this.addData("org.eclipse.scada.da.datasource.formula", id, data);
    }
}

