/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.validator.handler;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.configuration.world.lib.validator.DataSourceDescriptor;
import org.eclipse.scada.configuration.world.lib.validator.handler.LoopHandler;
import org.eclipse.scada.configuration.world.lib.validator.handler.NoOpHandler;

public class SimpleAttributeHandler
extends NoOpHandler
implements LoopHandler {
    private final String attributeName;
    private final String type;
    private final String referenceType;
    private final String splitPattern;

    public SimpleAttributeHandler(String type, String referenceType, String attributeName, String splitPattern) {
        this.type = type;
        this.referenceType = referenceType;
        this.attributeName = attributeName;
        this.splitPattern = splitPattern;
    }

    public SimpleAttributeHandler(String type, String referenceType, String attributeName) {
        this(type, referenceType, attributeName, null);
    }

    @Override
    public Set<DataSourceDescriptor> getNode(String configurationId, Map<String, String> parameters) {
        DataSourceDescriptor desc = new DataSourceDescriptor(this.type, configurationId);
        String reference = parameters.get(this.attributeName);
        if (reference == null || reference.isEmpty()) {
            return Collections.emptySet();
        }
        if (this.splitPattern != null) {
            String[] stringArray = reference.split(this.splitPattern);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String ref = stringArray[n2];
                desc.addReference(this.referenceType, ref);
                ++n2;
            }
        } else {
            desc.addReference(this.referenceType, reference);
        }
        return new HashSet<DataSourceDescriptor>(Arrays.asList(desc));
    }

    @Override
    public boolean providesDescriptors() {
        return true;
    }
}

