/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.memory.accessor;

import com.google.common.io.BaseEncoding;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.da.server.common.memory.accessor.Accessor;

public class FixedLengthBlobAccessor
implements Accessor<String> {
    private final int length;

    public FixedLengthBlobAccessor(int length) {
        this.length = length;
    }

    @Override
    public int getBufferSize(String value) {
        return this.length;
    }

    @Override
    public String get(IoBuffer data, int index) {
        return data.getSlice(index, this.length).getHexDump().toUpperCase();
    }

    @Override
    public void put(IoBuffer data, String value) {
        value = value.replaceAll("\\s", "");
        value = value.toUpperCase();
        data.put(BaseEncoding.base16().decode((CharSequence)value));
    }
}

