/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.memory.accessor;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.da.server.common.memory.accessor.Accessor;

public class FixedLengthStringAccessor
implements Accessor<String> {
    private final int length;
    private final Charset charset;

    public FixedLengthStringAccessor(int length, Charset charset) {
        this.length = length;
        this.charset = charset;
    }

    @Override
    public int getBufferSize(String value) {
        return this.length;
    }

    @Override
    public String get(IoBuffer data, int index) {
        try {
            return data.getString(this.length, this.charset.newDecoder());
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void put(IoBuffer data, String value) {
        if (value == null) {
            data.put((byte)0);
        }
        try {
            data.putString((CharSequence)value, this.length, this.charset.newEncoder());
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }
}

