/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.arduino;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Calendar;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioDatagramConnector;
import org.eclipse.scada.protocol.arduino.ArduinoCodec;
import org.eclipse.scada.protocol.arduino.ArduinoDeviceListener;
import org.eclipse.scada.protocol.arduino.CommandCode;
import org.eclipse.scada.protocol.arduino.DeviceState;
import org.eclipse.scada.protocol.arduino.messages.CommonMessage;
import org.eclipse.scada.protocol.arduino.messages.ConfigurationMessage;
import org.eclipse.scada.protocol.arduino.messages.DataMessage;
import org.eclipse.scada.protocol.arduino.messages.WriteRequestMessage;
import org.eclipse.scada.utils.concurrent.ScheduledExportedExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArduinoDevice
extends IoHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ArduinoDevice.class);
    private static final long TIMEOUT = Long.getLong("org.eclipse.scada.protocol.arduino.timeout", 2000L);
    private static final long POLL_TIME = Long.getLong("org.eclipse.scada.protocol.arduino.pollTime", 100L);
    private static final long POLL_TIMEOUT = Long.getLong("org.eclipse.scada.protocol.arduino.pollTimeout", 1000L);
    private final InetSocketAddress address;
    private boolean started = false;
    private ScheduledExecutorService executorService;
    private IoSession session;
    private DeviceState state;
    private int sequence;
    private final ArduinoDeviceListener listener;
    private NioDatagramConnector connector;
    private ScheduledFuture<?> connectJob;
    private ScheduledFuture<?> requestJob;
    private Calendar lastData;
    private Calendar lastRequest;
    private final boolean activateLogger;
    private long timeout = TIMEOUT;
    private long pollTime = POLL_TIME;
    private long pollTimeout = POLL_TIMEOUT;

    public ArduinoDevice(InetSocketAddress address, ArduinoDeviceListener listener, boolean activateLogger) {
        this.address = address;
        this.listener = listener;
        this.activateLogger = activateLogger;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setPollTime(long pollTime) {
        this.pollTime = pollTime;
    }

    public void setPollTimeout(long pollTimeout) {
        this.pollTimeout = pollTimeout;
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.executorService = ScheduledExportedExecutorService.newSingleThreadExportedScheduledExecutor((String)("ArduninoDevice/" + this.address));
        this.connector = new NioDatagramConnector();
        this.connector.setHandler((IoHandler)this);
        if (this.activateLogger) {
            this.connector.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter(((Object)((Object)this)).getClass().getName()));
        }
        ArduinoCodec codec = new ArduinoCodec();
        this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolEncoder)codec, (ProtocolDecoder)codec));
        this.connector.connect((SocketAddress)this.address);
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.connector.dispose();
        if (this.session != null) {
            this.session.close(true);
        }
        this.executorService.shutdown();
        this.executorService = null;
    }

    public void sessionCreated(IoSession session) throws Exception {
        this.sequence = 0;
        this.setState(DeviceState.DISCONNECTED);
        this.session = session;
    }

    private synchronized void setState(final DeviceState state) {
        logger.debug("State changed: {}", (Object)state);
        this.state = state;
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                ArduinoDevice.this.listener.stateChange(state);
                if (state == DeviceState.DISCONNECTED) {
                    ArduinoDevice.this.listener.deviceDisconnected();
                }
            }
        });
    }

    public void sessionOpened(IoSession session) throws Exception {
        this.connect();
    }

    public void sessionClosed(IoSession session) throws Exception {
        this.session = null;
        this.setState(DeviceState.DISCONNECTED);
    }

    private void connect() {
        this.setState(DeviceState.CONNECTING);
        this.session.write((Object)new CommonMessage(this.sequence++, CommandCode.REQUEST_CONFIGURATION));
        this.connectJob = this.executorService.schedule(new Runnable(){

            @Override
            public void run() {
                ArduinoDevice.this.connectTimeout();
            }
        }, 10L, TimeUnit.SECONDS);
    }

    protected synchronized void connectTimeout() {
        if (!this.started) {
            return;
        }
        this.setState(DeviceState.DISCONNECTED);
        this.triggerReconnect();
    }

    private synchronized void triggerReconnect() {
        this.connectJob = this.executorService.schedule(new Runnable(){

            @Override
            public void run() {
                ArduinoDevice.this.connect();
            }
        }, this.timeout, TimeUnit.MILLISECONDS);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        if (message instanceof CommonMessage) {
            switch (((CommonMessage)message).getCommandCode()) {
                case RESPOND_CONFIGURATION: {
                    this.respondConfiguration((ConfigurationMessage)message);
                    break;
                }
                case RESPOND_DATA: {
                    this.respondData((DataMessage)message);
                }
            }
        }
    }

    private synchronized void respondData(final DataMessage message) {
        this.lastData = Calendar.getInstance();
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                ArduinoDevice.this.listener.dataChange(message.getData());
            }
        });
    }

    private synchronized void respondConfiguration(final ConfigurationMessage message) {
        if (this.state != DeviceState.CONNECTING) {
            return;
        }
        this.setState(DeviceState.CONNECTED);
        if (this.connectJob != null) {
            this.connectJob.cancel(false);
            this.connectJob = null;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                ArduinoDevice.this.listener.deviceConnected(message.getParameters());
            }
        });
        this.startRequestJob();
        this.triggerRequest();
    }

    private synchronized void startRequestJob() {
        this.stopRequestJob();
        this.lastData = Calendar.getInstance();
        this.requestJob = this.executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ArduinoDevice.this.checkTimeout();
                ArduinoDevice.this.triggerRequest();
            }
        }, this.pollTime, this.pollTime, TimeUnit.MILLISECONDS);
    }

    protected synchronized void checkTimeout() {
        if (this.lastData != null && System.currentTimeMillis() - this.lastData.getTimeInMillis() > this.timeout) {
            this.handleTimeout();
        }
    }

    private synchronized void stopRequestJob() {
        if (this.requestJob != null) {
            this.requestJob.cancel(false);
            this.requestJob = null;
        }
    }

    protected synchronized void triggerRequest() {
        if (this.state != DeviceState.CONNECTED) {
            return;
        }
        if (this.lastRequest == null || System.currentTimeMillis() - this.lastRequest.getTimeInMillis() > this.pollTimeout) {
            this.lastRequest = Calendar.getInstance();
            this.session.write((Object)new CommonMessage(this.sequence++, CommandCode.REQUEST_DATA));
        }
    }

    protected synchronized void handleTimeout() {
        this.stopRequestJob();
        this.setState(DeviceState.DISCONNECTED);
        this.triggerReconnect();
    }

    public synchronized void sendWrite(short itemIndex, Object value) {
        this.session.write((Object)new WriteRequestMessage(this.sequence++, itemIndex, value));
    }
}

