/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.common.io;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimedEndDecoder
implements ProtocolDecoder {
    private static final Logger logger = LoggerFactory.getLogger(TimedEndDecoder.class);
    private static final String CONTEXT = "timedEndContext";
    private final Set<Context> contextSet = new CopyOnWriteArraySet<Context>();
    private final ScheduledExecutorService scheduler;
    private ScheduledFuture<?> job;
    private final long timeout;
    protected IoFilter.NextFilter nextFilter;

    public TimedEndDecoder(ScheduledExecutorService scheduler, long timeout, TimeUnit timeUnit) {
        this.scheduler = scheduler;
        this.timeout = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
        logger.debug("Running with a timeout of {} ms", (Object)this.timeout);
    }

    private synchronized void addJob() {
        logger.trace("Request add job");
        if (this.job == null) {
            logger.trace("Added job");
            this.job = this.scheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    TimedEndDecoder.this.tick();
                }
            }, this.timeout, this.timeout, TimeUnit.MILLISECONDS);
        }
    }

    private synchronized void removeJob() {
        logger.trace("Request remove job");
        if (this.job != null) {
            logger.trace("Removed job");
            this.job.cancel(false);
            this.job = null;
        }
    }

    protected void tick() {
        logger.trace("Checking contexts");
        int i = 0;
        for (Context ctx : this.contextSet) {
            ctx.check();
            ++i;
        }
        logger.trace("Checked {}", (Object)i);
    }

    public void dispose(IoSession session) throws Exception {
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
        Context ctx = (Context)session.removeAttribute((Object)CONTEXT);
        if (ctx != null) {
            this.unregisterContext(ctx);
            ctx.dispose();
        }
    }

    private synchronized void registerContext(Context ctx) {
        logger.trace("Register context: {}", (Object)ctx);
        this.contextSet.add(ctx);
        if (this.contextSet.size() == 1) {
            this.addJob();
        }
    }

    private synchronized void unregisterContext(Context ctx) {
        logger.trace("Unregister context: {}", (Object)ctx);
        this.contextSet.remove(ctx);
        if (this.contextSet.isEmpty()) {
            this.removeJob();
        }
    }

    public abstract void timeout(IoSession var1, ProtocolDecoderOutput var2) throws Exception;

    private void wrapTimeout(IoSession session, ProtocolDecoderOutput out) {
        try {
            this.timeout(session, out);
        }
        catch (Throwable e) {
            try {
                session.getHandler().exceptionCaught(session, e);
            }
            catch (Throwable ee) {
                logger.warn("Exception was thrown during handling Exception", ee);
            }
        }
    }

    public void tick(IoSession session, ProtocolDecoderOutput out) {
        logger.trace("Ticking for session: {}", (Object)session);
        this.getTimedContext(session, true).tick(out);
    }

    public void clear(IoSession session) {
        logger.trace("Clear for session: {}", (Object)session);
        Context ctx = this.getTimedContext(session, false);
        if (ctx != null) {
            ctx.clear();
            this.unregisterContext(ctx);
            session.removeAttribute((Object)CONTEXT);
        }
    }

    private Context getTimedContext(IoSession session, boolean create) {
        Context ctx = (Context)session.getAttribute((Object)CONTEXT);
        if (ctx == null && create) {
            logger.trace("Creating context for: {}", (Object)session);
            ctx = new Context(this, this.timeout, session);
            this.registerContext(ctx);
            session.setAttribute((Object)CONTEXT, (Object)ctx);
        }
        return ctx;
    }

    public synchronized void setNextFilter(IoFilter.NextFilter nextFilter) {
        this.nextFilter = nextFilter;
    }

    private class Context {
        private Long lastData = null;
        private final TimedEndDecoder decoder;
        private final long timeout;
        private final IoSession session;
        private boolean disposed = false;
        private ProtocolDecoderOutput out;

        public Context(TimedEndDecoder decoder, long timeout, IoSession session) {
            this.decoder = decoder;
            this.timeout = timeout;
            this.session = session;
        }

        public synchronized void tick(ProtocolDecoderOutput out) {
            this.lastData = System.currentTimeMillis();
            this.out = out;
        }

        public synchronized void clear() {
            this.lastData = null;
            this.out = null;
        }

        public synchronized void check() {
            if (this.disposed) {
                return;
            }
            if (this.lastData == null) {
                return;
            }
            if (System.currentTimeMillis() - this.lastData > this.timeout) {
                ProtocolDecoderOutput out = this.out;
                TimedEndDecoder.this.clear(this.session);
                this.decoder.wrapTimeout(this.session, out);
            }
        }

        public synchronized void dispose() {
            this.disposed = true;
        }
    }
}

