/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.pkg.deb;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.eclipse.scada.utils.pkg.deb.BinaryPackageBuilder;
import org.eclipse.scada.utils.pkg.deb.ContentProvider;
import org.eclipse.scada.utils.pkg.deb.EntryInformation;
import org.eclipse.scada.utils.pkg.deb.FileContentProvider;
import org.eclipse.scada.utils.pkg.deb.StaticContentProvider;
import org.eclipse.scada.utils.pkg.deb.TimestampProvider;
import org.eclipse.scada.utils.pkg.deb.control.BinaryPackageControlFile;
import org.eclipse.scada.utils.pkg.deb.control.ControlFileWriter;
import org.eclipse.scada.utils.pkg.deb.control.GenericControlFile;
import org.eclipse.scada.utils.pkg.deb.stream.ChecksumInputStream;
import org.eclipse.scada.utils.str.StringHelper;

public class DebianPackageWriter
implements AutoCloseable,
BinaryPackageBuilder {
    private static final int AR_ARCHIVE_DEFAULT_MODE = 33188;
    public static final Charset CHARSET = Charset.forName("UTF-8");
    private final ArArchiveOutputStream ar;
    private final byte[] binaryHeader = "2.0\n".getBytes();
    private final File dataTemp;
    private final TarArchiveOutputStream dataStream;
    private final GenericControlFile packageControlFile;
    private final TimestampProvider timestampProvider;
    private long installedSize = 0L;
    private final Map<String, String> checkSums = new TreeMap<String, String>();
    private final Set<String> confFiles = new TreeSet<String>();
    private final Set<String> paths = new HashSet<String>();
    private ContentProvider preinstScript;
    private ContentProvider postinstScript;
    private ContentProvider prermScript;
    private ContentProvider postrmScript;

    public DebianPackageWriter(OutputStream stream, GenericControlFile packageControlFile) throws IOException {
        this(stream, packageControlFile, TimestampProvider.DEFAULT_TIMESTAMP_PROVIDER);
    }

    public DebianPackageWriter(OutputStream stream, GenericControlFile packageControlFile, TimestampProvider timestampProvider) throws IOException {
        this.packageControlFile = packageControlFile;
        this.timestampProvider = timestampProvider;
        if (this.getTimestampProvider() == null) {
            throw new IllegalArgumentException("'timestampProvider' must not be null");
        }
        BinaryPackageControlFile.validate(packageControlFile);
        this.ar = new ArArchiveOutputStream(stream);
        this.ar.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("debian-binary", (long)this.binaryHeader.length, 0, 0, 33188, this.getTimestampProvider().getModTime() / 1000L));
        this.ar.write(this.binaryHeader);
        this.ar.closeArchiveEntry();
        this.dataTemp = File.createTempFile("data", null);
        this.dataStream = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new FileOutputStream(this.dataTemp)));
        this.dataStream.setLongFileMode(2);
    }

    public void addFile(File file, String fileName, EntryInformation entryInformation) throws IOException {
        this.addFile(new FileContentProvider(file), fileName, entryInformation);
    }

    public void addFile(byte[] content, String fileName, EntryInformation entryInformation) throws IOException {
        this.addFile(new StaticContentProvider(content), fileName, entryInformation);
    }

    public void addFile(String content, String fileName, EntryInformation entryInformation) throws IOException {
        this.addFile(new StaticContentProvider(content), fileName, entryInformation);
    }

    @Override
    public void addFile(ContentProvider contentProvider, String fileName, EntryInformation entryInformation) throws IOException {
        if (entryInformation == null) {
            entryInformation = EntryInformation.DEFAULT_FILE;
        }
        try {
            fileName = this.cleanupPath(fileName);
            if (entryInformation.isConfigurationFile()) {
                this.confFiles.add(fileName.substring(1));
            }
            TarArchiveEntry entry = new TarArchiveEntry(fileName);
            entry.setSize(contentProvider.getSize());
            DebianPackageWriter.applyInfo(entry, entryInformation, this.getTimestampProvider());
            this.checkCreateParents(fileName);
            this.dataStream.putArchiveEntry((ArchiveEntry)entry);
            HashMap<String, byte[]> results = new HashMap<String, byte[]>();
            Throwable throwable = null;
            Object var7_9 = null;
            try (ChecksumInputStream in = new ChecksumInputStream(contentProvider.createInputStream(), results, MessageDigest.getInstance("MD5"));){
                this.installedSize += ByteStreams.copy((InputStream)in, (OutputStream)this.dataStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.dataStream.closeArchiveEntry();
            this.recordChecksum(fileName, (byte[])results.get("MD5"));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private String cleanupPath(String fileName) {
        if (fileName == null) {
            return null;
        }
        fileName = fileName.replace("\\", "/");
        if ((fileName = fileName.replace("/+", "/")).startsWith("./")) {
            return fileName;
        }
        if (fileName.startsWith("/")) {
            return "." + fileName;
        }
        return "./" + fileName;
    }

    @Override
    public void addDirectory(String directory, EntryInformation entryInformation) throws IOException {
        if (!(directory = this.cleanupPath(directory)).endsWith("/")) {
            directory = String.valueOf(directory) + '/';
        }
        this.checkCreateParents(directory);
        this.internalAddDirectory(directory, entryInformation);
    }

    protected void internalAddDirectory(String path, EntryInformation entryInformation) throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(path);
        DebianPackageWriter.applyInfo(entry, entryInformation, this.getTimestampProvider());
        this.dataStream.putArchiveEntry((ArchiveEntry)entry);
        this.dataStream.closeArchiveEntry();
        this.paths.add(path);
    }

    private static void applyInfo(TarArchiveEntry entry, EntryInformation entryInformation, TimestampProvider timestampProvider) {
        if (entryInformation == null) {
            return;
        }
        if (entryInformation.getUser() != null) {
            entry.setUserName(entryInformation.getUser());
        }
        if (entryInformation.getGroup() != null) {
            entry.setGroupName(entryInformation.getGroup());
        }
        entry.setMode(entryInformation.getMode());
        entry.setModTime(timestampProvider.getModTime());
    }

    private void checkCreateParents(String fileName) throws IOException {
        String[] toks = fileName.split("/+");
        String current = "";
        int i = 0;
        while (i < toks.length - 1) {
            if (!toks[i].isEmpty() && !this.paths.contains(current = String.valueOf(current) + toks[i] + "/")) {
                this.internalAddDirectory(current, EntryInformation.DEFAULT_DIRECTORY);
            }
            ++i;
        }
    }

    private void recordChecksum(String fileName, byte[] bs) {
        this.checkSums.put(fileName, StringHelper.toHex((byte[])bs));
    }

    @Override
    public void close() throws IOException {
        try {
            try {
                this.buildAndAddControlFile();
                this.dataStream.close();
                this.addArFile(this.dataTemp, "data.tar.gz");
            }
            finally {
                this.ar.close();
            }
        }
        finally {
            this.dataTemp.delete();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildAndAddControlFile() throws IOException, FileNotFoundException {
        File controlFile = File.createTempFile("control", null);
        try {
            block16: {
                Throwable throwable = null;
                Object var3_4 = null;
                try {
                    GZIPOutputStream gout = new GZIPOutputStream(new FileOutputStream(controlFile));
                    try {
                        try (TarArchiveOutputStream tout = new TarArchiveOutputStream((OutputStream)gout);){
                            tout.setLongFileMode(2);
                            this.addControlContent(tout, "control", this.createControlContent(), -1);
                            this.addControlContent(tout, "md5sums", this.createChecksumContent(), -1);
                            this.addControlContent(tout, "conffiles", this.createConfFilesContent(), -1);
                            this.addControlContent(tout, "preinst", this.preinstScript, EntryInformation.DEFAULT_FILE_EXEC.getMode());
                            this.addControlContent(tout, "prerm", this.prermScript, EntryInformation.DEFAULT_FILE_EXEC.getMode());
                            this.addControlContent(tout, "postinst", this.postinstScript, EntryInformation.DEFAULT_FILE_EXEC.getMode());
                            this.addControlContent(tout, "postrm", this.postrmScript, EntryInformation.DEFAULT_FILE_EXEC.getMode());
                        }
                        if (gout == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (gout == null) throw throwable;
                        gout.close();
                        throw throwable;
                    }
                    gout.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            this.addArFile(controlFile, "control.tar.gz");
            return;
        }
        finally {
            controlFile.delete();
        }
    }

    private void addControlContent(TarArchiveOutputStream out, String name, ContentProvider content, int mode) throws IOException {
        if (content == null || !content.hasContent()) {
            return;
        }
        TarArchiveEntry entry = new TarArchiveEntry(name);
        if (mode >= 0) {
            entry.setMode(mode);
        }
        entry.setUserName("root");
        entry.setGroupName("root");
        entry.setSize(content.getSize());
        entry.setModTime(this.getTimestampProvider().getModTime());
        out.putArchiveEntry((ArchiveEntry)entry);
        Throwable throwable = null;
        Object var7_8 = null;
        try (InputStream stream = content.createInputStream();){
            ByteStreams.copy((InputStream)stream, (OutputStream)out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        out.closeArchiveEntry();
    }

    protected ContentProvider createControlContent() throws IOException {
        this.packageControlFile.set(BinaryPackageControlFile.Fields.INSTALLED_SIZE, "" + this.installedSize);
        StringWriter sw = new StringWriter();
        Throwable throwable = null;
        Object var3_4 = null;
        try (ControlFileWriter writer = new ControlFileWriter(sw);){
            this.packageControlFile.write(writer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        sw.close();
        return new StaticContentProvider(sw.toString());
    }

    protected ContentProvider createChecksumContent() throws IOException {
        if (this.checkSums.isEmpty()) {
            return ContentProvider.NULL_CONTENT;
        }
        StringWriter sw = new StringWriter();
        for (Map.Entry<String, String> entry : this.checkSums.entrySet()) {
            String filename = entry.getKey().substring(2);
            sw.append(entry.getValue());
            sw.append("  ");
            sw.append(filename);
            sw.append('\n');
        }
        sw.close();
        return new StaticContentProvider(sw.toString());
    }

    protected ContentProvider createConfFilesContent() throws IOException {
        if (this.confFiles.isEmpty()) {
            return ContentProvider.NULL_CONTENT;
        }
        StringWriter sw = new StringWriter();
        for (String confFile : this.confFiles) {
            sw.append(confFile).append('\n');
        }
        sw.close();
        return new StaticContentProvider(sw.toString());
    }

    private void addArFile(File file, String entryName) throws IOException {
        ArArchiveEntry entry = new ArArchiveEntry(entryName, file.length(), 0, 0, 33188, this.timestampProvider.getModTime() / 1000L);
        this.ar.putArchiveEntry((ArchiveEntry)entry);
        ByteStreams.copy((InputStream)new FileInputStream(file), (OutputStream)this.ar);
        this.ar.closeArchiveEntry();
    }

    public void setPostinstScript(ContentProvider postinstScript) {
        this.postinstScript = postinstScript;
    }

    public void setPostrmScript(ContentProvider postrmScript) {
        this.postrmScript = postrmScript;
    }

    public void setPreinstScript(ContentProvider preinstScript) {
        this.preinstScript = preinstScript;
    }

    public void setPrermScript(ContentProvider prermScript) {
        this.prermScript = prermScript;
    }

    public TimestampProvider getTimestampProvider() {
        return this.timestampProvider;
    }
}

