/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.pkg.deb;

import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.scada.utils.pkg.deb.ContentProvider;

public class TextFileContentProvider
implements ContentProvider {
    private final byte[] data;

    public TextFileContentProvider(File file) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileReader reader = new FileReader(file);){
            if (file != null) {
                String data = CharStreams.toString((Readable)reader);
                if (TextFileContentProvider.needFix()) {
                    data = TextFileContentProvider.fix(data);
                }
                this.data = data.getBytes(StandardCharsets.UTF_8);
            } else {
                this.data = null;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static boolean needFix() {
        return !"\n".equals(System.lineSeparator());
    }

    private static String fix(String data) {
        return data.replace("\r\n", "\n");
    }

    @Override
    public long getSize() {
        return this.data == null ? 0 : this.data.length;
    }

    @Override
    public InputStream createInputStream() throws IOException {
        if (this.data != null) {
            return new ByteArrayInputStream(this.data);
        }
        return null;
    }

    @Override
    public boolean hasContent() {
        return this.data != null;
    }
}

