/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.pkg.deb;

import java.sql.Date;
import java.util.Calendar;
import java.util.GregorianCalendar;

public interface TimestampProvider {
    public static final DefaultTimestampProvider DEFAULT_TIMESTAMP_PROVIDER = new DefaultTimestampProvider();

    public long getModTime();

    public static final class DefaultTimestampProvider
    implements TimestampProvider {
        private final long now = System.currentTimeMillis();

        @Override
        public long getModTime() {
            return this.now / 1000L;
        }
    }

    public static final class SpecificTimestampProvider
    implements TimestampProvider {
        private final long ts;

        public SpecificTimestampProvider(long millis) {
            this.ts = millis;
        }

        public SpecificTimestampProvider(Date date) {
            this.ts = date.getTime();
        }

        public SpecificTimestampProvider(Calendar calendar) {
            this.ts = calendar.getTimeInMillis();
        }

        @Override
        public long getModTime() {
            return this.ts / 1000L;
        }
    }

    public static final class SpecificYearTimestampProvider
    implements TimestampProvider {
        private final long newYear;

        public SpecificYearTimestampProvider(int year) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.set(6, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.set(1, year);
            this.newYear = cal.getTimeInMillis();
        }

        @Override
        public long getModTime() {
            return this.newYear / 1000L;
        }
    }
}

