/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.pkg.deb.control;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.scada.utils.pkg.deb.control.ControlField;
import org.eclipse.scada.utils.pkg.deb.control.ControlFieldDefinition;
import org.eclipse.scada.utils.pkg.deb.control.FieldType;
import org.eclipse.scada.utils.pkg.deb.control.GenericControlFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryPackageControlFile
extends GenericControlFile {
    private static final Logger logger = LoggerFactory.getLogger(BinaryPackageControlFile.class);

    public void setPackage(String value) {
        this.set(Fields.PACKAGE.createField(value));
    }

    public String getPackage() {
        return this.getValue(Fields.PACKAGE);
    }

    public void setVersion(String value) {
        this.set(Fields.VERSION.createField(value));
    }

    public String getVersion() {
        return this.getValue(Fields.VERSION);
    }

    public String getArchitecture() {
        return this.getValue(Fields.ARCHITECTURE);
    }

    public void setArchitecture(String value) {
        this.set(Fields.ARCHITECTURE.createField(value));
    }

    public String getMaintainer() {
        return this.getValue(Fields.MAINTAINER);
    }

    public void setMaintainer(String value) {
        this.set(Fields.MAINTAINER.createField(value));
    }

    public void setDescription(String abstractLine, String details) {
        this.set(Fields.DESCRIPTION.createField(details, abstractLine));
    }

    public String getPriority() {
        return this.getValue(Fields.PRIORITY);
    }

    public void setPriority(String value) {
        this.set(Fields.PRIORITY.createField(value));
    }

    public String getSection() {
        return this.getValue(Fields.SECTION);
    }

    public void setSection(String value) {
        this.set(Fields.SECTION.createField(value));
    }

    public void validate() {
        BinaryPackageControlFile.validate(this);
    }

    public static void validate(GenericControlFile controlFile) {
        BinaryPackageControlFile.hasField(controlFile, Fields.PACKAGE);
        BinaryPackageControlFile.hasField(controlFile, Fields.ARCHITECTURE);
        BinaryPackageControlFile.hasField(controlFile, Fields.VERSION);
        BinaryPackageControlFile.hasField(controlFile, Fields.MAINTAINER);
        BinaryPackageControlFile.hasField(controlFile, Fields.DESCRIPTION);
    }

    private static void hasField(GenericControlFile controlFile, ControlFieldDefinition definition) {
        ControlField result = controlFile.get(definition);
        if (result == null) {
            throw new IllegalStateException(String.format("Control file must have field '%s'", definition.getName()));
        }
    }

    public String makeFileName() {
        String name = String.format("%s_%s_%s.deb", this.getPackage(), this.getVersion(), this.getArchitecture());
        try {
            return URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("Failed to encode package name", (Throwable)e);
            return name;
        }
    }

    public static interface Fields {
        public static final ControlFieldDefinition PACKAGE = new ControlFieldDefinition("Package", FieldType.SIMPLE);
        public static final ControlFieldDefinition VERSION = new ControlFieldDefinition("Version", FieldType.SIMPLE);
        public static final ControlFieldDefinition ARCHITECTURE = new ControlFieldDefinition("Architecture", FieldType.SIMPLE);
        public static final ControlFieldDefinition SECTION = new ControlFieldDefinition("Section", FieldType.SIMPLE);
        public static final ControlFieldDefinition PRIORITY = new ControlFieldDefinition("Priority", FieldType.SIMPLE);
        public static final ControlFieldDefinition ESSENTIAL = new ControlFieldDefinition("Essential", FieldType.SIMPLE);
        public static final ControlFieldDefinition DESCRIPTION = new ControlFieldDefinition("Description", FieldType.MULTILINE);
        public static final ControlFieldDefinition MAINTAINER = new ControlFieldDefinition("Maintainer", FieldType.SIMPLE);
        public static final ControlFieldDefinition INSTALLED_SIZE = new ControlFieldDefinition("Installed-Size", FieldType.SIMPLE);
        public static final ControlFieldDefinition CONFLICTS = new ControlFieldDefinition("Conflicts", FieldType.SIMPLE);
        public static final ControlFieldDefinition DEPENDS = new ControlFieldDefinition("Depends", FieldType.SIMPLE);
        public static final ControlFieldDefinition PRE_DEPENDS = new ControlFieldDefinition("Pre-Depends", FieldType.SIMPLE);
    }
}

