/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.pkg.deb.control;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.scada.utils.pkg.deb.control.ControlFieldDefinition;
import org.eclipse.scada.utils.pkg.deb.control.FieldType;

public class ControlField {
    private final String value;
    private final String firstLine;
    private final ControlFieldDefinition definition;

    ControlField(ControlFieldDefinition definition, String value, String firstLine) {
        this.definition = definition;
        this.value = value;
        this.firstLine = firstLine;
    }

    public ControlFieldDefinition getDefinition() {
        return this.definition;
    }

    public String getFirstLine() {
        return this.firstLine;
    }

    public String getValue() {
        return this.value;
    }

    public void write(Writer writer) throws IOException {
        String name = this.definition.getName();
        FieldType type = this.definition.getType();
        writer.write(name);
        writer.write(": ");
        switch (type) {
            case SIMPLE: {
                this.writeSimpleValue(writer);
                break;
            }
            case FOLDED: {
                this.writeFoldedValue(writer);
                break;
            }
            case MULTILINE: {
                this.writeMultiLineValue(writer);
            }
        }
    }

    private void writeSimpleValue(Writer writer) throws IOException {
        writer.write(this.value);
        writer.write(10);
    }

    private void writeFoldedValue(Writer writer) throws IOException {
        this.writeLines(writer, true, 78);
    }

    private void writeMultiLineValue(Writer writer) throws IOException {
        this.writeLines(writer, false, Integer.MAX_VALUE);
    }

    private void writeLines(Writer writer, boolean ignoreFirstLine, int maxLineLength) throws IOException {
        boolean lineBreak = false;
        if (!ignoreFirstLine) {
            if (this.firstLine != null) {
                writer.write(this.firstLine);
            }
            writer.write(10);
            lineBreak = true;
        }
        int lineLength = 0;
        int len = this.value.length();
        int i = 0;
        while (i < len) {
            char c = this.value.charAt(i);
            switch (c) {
                case '\n': {
                    if (lineBreak) {
                        writer.write(" .");
                    }
                    writer.write(10);
                    lineBreak = true;
                    lineLength = 0;
                    break;
                }
                default: {
                    if (lineLength > maxLineLength) {
                        lineLength = 0;
                        lineBreak = true;
                        writer.write(10);
                    }
                    if (lineBreak) {
                        lineBreak = false;
                        writer.write(32);
                    }
                    writer.write(c);
                    ++lineLength;
                }
            }
            ++i;
        }
        writer.write(10);
    }
}

