/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.pkg.deb.control;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scada.utils.pkg.deb.InvalidValueException;
import org.eclipse.scada.utils.pkg.deb.control.ControlField;
import org.eclipse.scada.utils.pkg.deb.control.FieldType;

public class ControlFieldDefinition
implements Comparable<ControlFieldDefinition> {
    private final String name;
    private final FieldType type;
    private final Pattern pattern;
    private final String id;

    public ControlFieldDefinition(String name, FieldType type, Pattern pattern) {
        ControlFieldDefinition.validateName(name);
        this.name = name;
        this.type = type;
        this.pattern = pattern;
        this.id = name.toUpperCase();
    }

    public ControlFieldDefinition(String name, FieldType type) {
        this(name, type, null);
    }

    public FieldType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void validateValue(String value) {
        if (value == null) {
            throw new InvalidValueException(String.format("Value must not be null", new Object[0]));
        }
        if (this.pattern == null) {
            return;
        }
        Matcher m = this.pattern.matcher(value);
        if (!m.matches()) {
            throw new InvalidValueException(String.format("Field '%s' must match pattern: %s", this.name, this.pattern.pattern()));
        }
    }

    public ControlField createField(String value, String firstLine) {
        this.validateValue(value);
        return new ControlField(this, value, firstLine);
    }

    public ControlField createField(String value) {
        return this.createField(value, null);
    }

    protected static void validateNonEmpty(String label, String value) throws InvalidValueException {
        if (value == null) {
            throw new InvalidValueException(String.format("'%s' must not be null", new Object[0]));
        }
        if (value.isEmpty()) {
            throw new InvalidValueException(String.format("'%s' must not be empty", new Object[0]));
        }
    }

    protected static void validateName(String name) throws InvalidValueException {
        ControlFieldDefinition.validateNonEmpty("Name", name);
        int i = 0;
        while (i < name.length()) {
            ControlFieldDefinition.validateFieldChar(name.charAt(i), name);
            ++i;
        }
    }

    private static void validateFieldChar(char c, String value) {
        if (c >= '!' && c <= '9' || c >= ';' && c <= '~') {
            return;
        }
        throw new InvalidValueException(String.format("String must be US-ASCII based letters only: %s", value));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ControlFieldDefinition other = (ControlFieldDefinition)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public int compareTo(ControlFieldDefinition other) {
        return this.id.compareTo(other.id);
    }
}

