/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.pkg.deb.control;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.scada.utils.pkg.deb.control.ControlField;
import org.eclipse.scada.utils.pkg.deb.control.ControlFieldDefinition;
import org.eclipse.scada.utils.pkg.deb.control.ControlFileWriter;

public class GenericControlFile {
    private final Map<ControlFieldDefinition, ControlField> fields = new TreeMap<ControlFieldDefinition, ControlField>();

    public void set(ControlField field) {
        this.fields.put(field.getDefinition(), field);
    }

    public void set(ControlFieldDefinition definition, String value) {
        this.fields.put(definition, definition.createField(value));
    }

    public ControlField get(ControlFieldDefinition definition) {
        return this.fields.get(definition);
    }

    public String getValue(ControlFieldDefinition definition) {
        ControlField field = this.fields.get(definition);
        if (field == null) {
            return null;
        }
        return field.getValue();
    }

    public void write(ControlFileWriter writer) throws IOException {
        for (Map.Entry<ControlFieldDefinition, ControlField> entry : this.fields.entrySet()) {
            writer.writeField(entry.getValue());
        }
    }
}

