/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.pkg.deb.stream;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Map;

public class ChecksumInputStream
extends FilterInputStream {
    private final MessageDigest[] digests;
    private final Map<String, byte[]> results;

    public ChecksumInputStream(InputStream stream, Map<String, byte[]> results, MessageDigest ... digests) {
        super(stream);
        this.digests = digests;
        this.results = results;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        if (result > 0) {
            MessageDigest[] messageDigestArray = this.digests;
            int n = this.digests.length;
            int n2 = 0;
            while (n2 < n) {
                MessageDigest d = messageDigestArray[n2];
                d.update(b, off, result);
                ++n2;
            }
        }
        return result;
    }

    @Override
    public int read() throws IOException {
        int result = super.read();
        if (result > 0) {
            MessageDigest[] messageDigestArray = this.digests;
            int n = this.digests.length;
            int n2 = 0;
            while (n2 < n) {
                MessageDigest d = messageDigestArray[n2];
                d.update((byte)result);
                ++n2;
            }
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        super.close();
        MessageDigest[] messageDigestArray = this.digests;
        int n = this.digests.length;
        int n2 = 0;
        while (n2 < n) {
            MessageDigest d = messageDigestArray[n2];
            byte[] result = d.digest();
            this.results.put(d.getAlgorithm(), result);
            ++n2;
        }
    }

    public Map<String, byte[]> getResults() {
        return this.results;
    }
}

