/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.monitor.datasource.common.bit;

import com.google.common.collect.Interner;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.scada.ae.data.Severity;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ae.monitor.datasource.AbstractBooleanMonitor;
import org.eclipse.scada.ae.monitor.datasource.AbstractMasterItemMonitor;
import org.eclipse.scada.ae.monitor.datasource.Helper;
import org.eclipse.scada.ae.monitor.datasource.common.bit.Configuration;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.core.WriteAttributeResult;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleContext;

public class BitMonitor
extends AbstractBooleanMonitor {
    private Configuration configuration;

    public BitMonitor(BundleContext context, Executor executor, Interner<String> stringInterner, ObjectPoolTracker<MasterItem> poolTracker, EventProcessor eventProcessor, String id, String prefix, String defaultMonitorType) {
        super(context, executor, stringInterner, poolTracker, eventProcessor, id, "org.eclipse.scada.ae.monitor.bit", prefix, defaultMonitorType);
    }

    protected int getDefaultHandlerPriority() {
        return 600;
    }

    protected void performBooleanUpdate(DataItemValue.Builder builder, boolean value) {
        if (this.configuration == null || this.configuration.reference == null) {
            this.setOk(builder.getValue(), Helper.getTimestamp((DataItemValue.Builder)builder));
            return;
        }
        boolean failure = value ^ this.configuration.reference;
        if (failure) {
            this.setFailure(builder.getValue(), Helper.getTimestamp((DataItemValue.Builder)builder), this.configuration.severity, this.configuration.requireAck);
        } else {
            this.setOk(builder.getValue(), Helper.getTimestamp((DataItemValue.Builder)builder));
        }
    }

    public synchronized void update(UserInformation userInformation, Map<String, String> properties) throws Exception {
        super.update(userInformation, properties);
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(properties);
        Configuration c = new Configuration(this.configuration, (AbstractMasterItemMonitor)this);
        c.setReference(userInformation, cfg.getBoolean("reference"));
        c.setSeverity(userInformation, (Severity)cfg.getEnum("severity", Severity.class, (Enum)Severity.ALARM));
        c.setRequireAck(userInformation, cfg.getBoolean("requireAck", false));
        c.sendEvents();
        this.configuration = c;
        this.reprocess();
    }

    protected void injectAttributes(DataItemValue.Builder builder) {
        super.injectAttributes(builder);
        if (this.configuration != null) {
            builder.setAttribute(this.intern(String.valueOf(this.getPrefix()) + ".reference"), Variant.valueOf((Object)this.configuration.reference));
        }
    }

    protected void handleConfigUpdate(Map<String, String> configUpdate, Map<String, Variant> attributes, WriteAttributeResults result) {
        super.handleConfigUpdate(configUpdate, attributes, result);
        Variant active = attributes.get(String.valueOf(this.getPrefix()) + ".reference");
        if (active != null) {
            configUpdate.put("reference", "" + active.asBoolean());
            result.put((Object)this.intern(String.valueOf(this.getPrefix()) + ".reference"), (Object)WriteAttributeResult.OK);
        }
    }
}

