/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.base.pipe.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.LinkedList;
import org.eclipse.scada.base.pipe.Worker;
import org.eclipse.scada.base.pipe.internal.PipeServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WorkerThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(WorkerThread.class);
    private final PipeServiceImpl pipeService;
    private final Worker worker;
    private final String pipeName;
    private boolean closing;
    private boolean closed;

    public WorkerThread(PipeServiceImpl pipeServiceImpl, Worker worker, String pipeName) {
        this.pipeService = pipeServiceImpl;
        this.worker = worker;
        this.pipeName = pipeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info("Starting worker thread: {} -> {}", (Object)this.pipeName, (Object)this.worker);
        try {
            while (!this.closing) {
                this.runOnce();
            }
        }
        catch (Throwable throwable) {
            logger.info("Closing worker thread");
            WorkerThread workerThread = this;
            synchronized (workerThread) {
                this.closed = true;
                this.notifyAll();
            }
            throw throwable;
        }
        logger.info("Closing worker thread");
        WorkerThread workerThread = this;
        synchronized (workerThread) {
            this.closed = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOnce() {
        LinkedList<File> files = new LinkedList<File>();
        WorkerThread workerThread = this;
        synchronized (workerThread) {
            Long endWait = this.pipeService.fetchNextEvents(this.pipeName, 100, files);
            logger.trace("Files found: {}", (Object)files.size());
            if (files.isEmpty()) {
                try {
                    logger.trace("Waiting for new content");
                    if (endWait != null) {
                        long delay = endWait - System.currentTimeMillis();
                        if (delay > 0L) {
                            logger.trace("Waiting for {} ms ...", (Object)delay);
                            this.wait(delay);
                        } else {
                            endWait = null;
                        }
                    } else {
                        logger.trace("Waiting...");
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (files.isEmpty()) {
            return;
        }
        logger.trace("Processing files");
        for (File file : files) {
            if (this.closing) {
                logger.debug("Early abort while processing...");
                return;
            }
            try {
                logger.trace("Processing: {}", (Object)file);
                byte[] data = Files.readAllBytes(file.toPath());
                boolean worked = false;
                try {
                    this.worker.work(data);
                    worked = true;
                }
                catch (Exception e) {
                    logger.info("Worker failed", (Throwable)e);
                }
                if (worked) {
                    Files.delete(file.toPath());
                    continue;
                }
                PipeServiceImpl.MetaInfo info = PipeServiceImpl.parse(file.getName());
                if (info != null) {
                    info.timestamp = System.currentTimeMillis() + 60000L;
                    --info.retry;
                }
                if (info.retry > 0L) {
                    File newFile = this.pipeService.makeFile(this.pipeName, info);
                    logger.debug("Postponing event - {} -> {}", (Object)file.getName(), (Object)newFile.getName());
                    Files.move(file.toPath(), newFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
                    continue;
                }
                logger.debug("Purging event - {}", (Object)file.getName());
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                logger.info("Failed to process file: " + file, (Throwable)e);
            }
        }
    }

    public synchronized void notifyNewEvent() {
        logger.trace("Notify worker thread");
        this.notifyAll();
    }

    public synchronized void close() {
        this.closing = true;
        this.notifyAll();
    }
}

