/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.server.osgi;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.ca.Configuration;
import org.eclipse.scada.ca.ConfigurationAdministrator;
import org.eclipse.scada.ca.Factory;
import org.eclipse.scada.ca.data.DiffEntry;
import org.eclipse.scada.ca.server.FactoryWithData;
import org.eclipse.scada.ca.server.Service;
import org.eclipse.scada.ca.server.Session;
import org.eclipse.scada.ca.server.osgi.SessionImpl;
import org.eclipse.scada.core.InvalidSessionException;
import org.eclipse.scada.core.data.OperationParameters;
import org.eclipse.scada.core.server.common.AuthorizedOperation;
import org.eclipse.scada.core.server.common.osgi.AbstractServiceImpl;
import org.eclipse.scada.core.server.common.session.AbstractSessionImpl;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.utils.concurrent.ExportedExecutorService;
import org.eclipse.scada.utils.concurrent.FutureTask;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.osgi.framework.BundleContext;

public class ServiceImpl
extends AbstractServiceImpl<Session, SessionImpl>
implements Service {
    private final ConfigurationAdministrator service;
    private final ExportedExecutorService executor;

    public ServiceImpl(ConfigurationAdministrator service, BundleContext context, Executor executor) throws Exception {
        super(context, executor);
        this.service = service;
        this.executor = new ExportedExecutorService("org.eclipse.scada.ca.server.osgi.ServiceImpl", 1, 1, 1L, TimeUnit.MINUTES);
    }

    public void stop() throws Exception {
        super.stop();
        this.executor.shutdown();
    }

    protected SessionImpl createSessionInstance(UserInformation userInformation, Map<String, String> properties) {
        return new SessionImpl(userInformation, properties);
    }

    public synchronized NotifyFuture<Void> applyDiff(Session session, final Collection<DiffEntry> changeSet, OperationParameters operationParameters, CallbackHandler callbackHandler) throws InvalidSessionException {
        SessionImpl sessionImpl = (SessionImpl)this.validateSession((org.eclipse.scada.core.server.Session)session, SessionImpl.class);
        return new AuthorizedOperation<Void, AbstractSessionImpl>(this.authorizationProvider, (AbstractSessionImpl)sessionImpl, "CFG", null, "APPLY_DIFF", null, operationParameters, callbackHandler, DEFAULT_RESULT){

            protected NotifyFuture<Void> granted(org.eclipse.scada.core.server.OperationParameters effectiveOperationParameters) {
                return ServiceImpl.this.processApplyDiff(effectiveOperationParameters.getUserInformation(), changeSet);
            }
        };
    }

    protected NotifyFuture<Void> processApplyDiff(UserInformation userInformation, Collection<DiffEntry> changeSet) {
        return this.service.applyDiff(userInformation, changeSet);
    }

    public synchronized NotifyFuture<FactoryWithData> getFactory(Session session, final String factoryId) throws InvalidSessionException {
        this.validateSession((org.eclipse.scada.core.server.Session)session, SessionImpl.class);
        FutureTask task = new FutureTask((Callable)new Callable<FactoryWithData>(){

            @Override
            public FactoryWithData call() throws Exception {
                Factory factory = ServiceImpl.this.service.getFactory(factoryId);
                Configuration[] configurations = ServiceImpl.this.service.getConfigurations(factoryId);
                return new FactoryWithData(factory, configurations);
            }
        });
        this.executor.submit((Runnable)task);
        return task;
    }

    public synchronized NotifyFuture<Factory[]> getKnownFactories(Session session) throws InvalidSessionException {
        this.validateSession((org.eclipse.scada.core.server.Session)session, SessionImpl.class);
        FutureTask task = new FutureTask((Callable)new Callable<Factory[]>(){

            @Override
            public Factory[] call() throws Exception {
                return ServiceImpl.this.service.getKnownFactories();
            }
        });
        this.executor.submit((Runnable)task);
        return task;
    }

    public NotifyFuture<Configuration[]> getConfigurations(Session session, final String factoryId) throws InvalidSessionException {
        this.validateSession((org.eclipse.scada.core.server.Session)session, SessionImpl.class);
        FutureTask task = new FutureTask((Callable)new Callable<Configuration[]>(){

            @Override
            public Configuration[] call() throws Exception {
                return ServiceImpl.this.service.getConfigurations(factoryId);
            }
        });
        this.executor.submit((Runnable)task);
        return task;
    }

    public synchronized NotifyFuture<Configuration> getConfiguration(Session session, final String factoryId, final String configurationId) throws InvalidSessionException {
        this.validateSession((org.eclipse.scada.core.server.Session)session, SessionImpl.class);
        FutureTask task = new FutureTask((Callable)new Callable<Configuration>(){

            @Override
            public Configuration call() throws Exception {
                return ServiceImpl.this.service.getConfiguration(factoryId, configurationId);
            }
        });
        this.executor.submit((Runnable)task);
        return task;
    }
}

