/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.setup.common.validation;

import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.scada.configuration.setup.common.CommonPackage;
import org.eclipse.scada.configuration.setup.common.SerialToNetworkMapping;
import org.eclipse.scada.utils.ecore.validation.TypedValidator;
import org.eclipse.scada.utils.ecore.validation.ValidationContext;
import org.eclipse.scada.utils.str.StringHelper;

public class SerialMappingValidator
extends TypedValidator<SerialToNetworkMapping> {
    private static final int MIN_PORT = 1;
    private static final int MAX_PORT = 65535;
    private static final Set<Integer> validDataBits = new TreeSet<Integer>(Arrays.asList(7, 8));
    private static final Set<Integer> validStopBits = new TreeSet<Integer>(Arrays.asList(1, 2));

    public SerialMappingValidator() {
        super(SerialToNetworkMapping.class);
    }

    protected void validate(SerialToNetworkMapping target, ValidationContext context) {
        if (target.getBaudRate() <= 0) {
            context.add((EStructuralFeature)CommonPackage.Literals.SERIAL_TO_NETWORK_MAPPING__BAUD_RATE, "Baud rate must be greater than zero", new Object[0]);
        }
        if (!validDataBits.contains(target.getDataBits())) {
            context.add((EStructuralFeature)CommonPackage.Literals.SERIAL_TO_NETWORK_MAPPING__DATA_BITS, "Data bits must be one of: {0}", new Object[]{StringHelper.join(validDataBits, (String)", ")});
        }
        if (!validStopBits.contains(target.getStopBits())) {
            context.add((EStructuralFeature)CommonPackage.Literals.SERIAL_TO_NETWORK_MAPPING__STOP_BITS, "Stop bits must be one of: {0}", new Object[]{StringHelper.join(validStopBits, (String)", ")});
        }
        if (target.getTcpPort() < 1 || target.getTcpPort() > 65535) {
            context.add((EStructuralFeature)CommonPackage.Literals.SERIAL_TO_NETWORK_MAPPING__TCP_PORT, "TCP port must be between {0} and {1}", new Object[]{1, 65535});
        }
    }
}

