/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hds;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Date;
import org.eclipse.scada.hds.DataFileAccessor;
import org.eclipse.scada.hds.ValueVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFileAccessorImpl
implements DataFileAccessor {
    private static final Logger logger = LoggerFactory.getLogger(DataFileAccessorImpl.class);
    public static final byte FLAG_DELETED = 8;
    public static final byte FLAG_HEARTBEAT = 4;
    public static final byte FLAG_MANUAL = 2;
    public static final byte FLAG_ERROR = 1;
    protected static final int HEADER_SIZE = 24;
    protected static final int ENTRY_SIZE = 17;
    protected RandomAccessFile file;
    protected final FileChannel channel;
    protected Date start;
    protected Date end;
    private final File fileInfo;

    public DataFileAccessorImpl(File file) throws Exception {
        this.fileInfo = file;
        this.file = new RandomAccessFile(file, "rw");
        try {
            this.channel = this.file.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(24);
            while (buffer.hasRemaining()) {
                int rc = this.channel.read(buffer);
                if (rc < 0) break;
                logger.debug("Read {} bytes", (Object)rc);
            }
            buffer.flip();
            int magic = buffer.getInt();
            int version = buffer.getInt();
            this.start = new Date(buffer.getLong());
            this.end = new Date(buffer.getLong());
            logger.debug("Header - magic: {}, version: {}, start: {}, end: {}", new Object[]{magic, version, this.start, this.end});
            if (logger.isDebugEnabled()) {
                logger.debug("File position after header: {}", (Object)this.channel.position());
            }
            this.channel.position(this.channel.size());
        }
        catch (Exception e) {
            logger.warn("Failed to open file", (Throwable)e);
            this.file.close();
            throw e;
        }
    }

    @Override
    public Date getStart() {
        return this.start;
    }

    @Override
    public Date getEnd() {
        return this.end;
    }

    @Override
    public void insertValue(double value, Date date, boolean error, boolean manual, boolean heartbeat) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("File position - before: {}", (Object)this.channel.position());
        }
        ByteBuffer buffer = ByteBuffer.allocate(100);
        buffer.putDouble(value);
        buffer.putLong(date.getTime());
        byte flag = heartbeat ? (byte)4 : (byte)((error ? 1 : 0) | (manual ? 2 : 0));
        logger.debug("Writing flag: {}", (Object)flag);
        buffer.put(flag);
        buffer.flip();
        while (buffer.hasRemaining()) {
            int rc = this.channel.write(buffer);
            if (rc < 0) {
                throw new IOException("Failed to write data");
            }
            logger.debug("Wrote {} bytes", (Object)rc);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("File position - after: {}", (Object)this.channel.position());
        }
    }

    @Override
    public boolean visitFirstValue(ValueVisitor visitor) throws Exception {
        logger.debug("Welcome backwards seeking visitor: {}", (Object)visitor);
        long startPosition = this.channel.position();
        logger.debug("Seeking at position: {}", (Object)startPosition);
        ByteBuffer buffer = ByteBuffer.allocate(17);
        try {
            while (this.channel.position() > 24L) {
                logger.debug("At position: {}", (Object)this.channel.position());
                this.channel.position(this.channel.position() - 17L);
                if (this.safeRead(buffer) != 17) {
                    break;
                }
                buffer.flip();
                double value = buffer.getDouble();
                Date timestamp = new Date(buffer.getLong());
                byte flags = buffer.get();
                logger.debug("Stumbled upon {}/{}/{} when searching backwards", new Object[]{value, timestamp, flags});
                if ((flags & 4) == 0 && (flags & 8) == 0 && !Double.isNaN(value)) {
                    visitor.value(value, timestamp, (flags & 1) > 0, (flags & 2) > 0);
                    return true;
                }
                buffer.clear();
                this.channel.position(this.channel.position() - 17L);
            }
        }
        finally {
            this.channel.position(startPosition);
            logger.debug("Returned to position: {}", (Object)startPosition);
        }
        return false;
    }

    public boolean forwardVisitAll(EntryVisitor visitor) throws IOException {
        long position = this.channel.position();
        try {
            this.channel.position(24L);
            ByteBuffer buffer = ByteBuffer.allocate(17);
            while (this.safeRead(buffer) == 17) {
                buffer.flip();
                double value = buffer.getDouble();
                long timestamp = buffer.getLong();
                byte flags = buffer.get();
                logger.debug("Visit value - flag: {}", (Object)flags);
                boolean cont = visitor.visitEntry(timestamp, value, flags);
                if (!cont) {
                    logger.debug("Stopping visit by request on visitor");
                    return false;
                }
                buffer.clear();
            }
        }
        finally {
            this.channel.position(position);
            logger.debug("Returned to position: {}", (Object)position);
        }
        return true;
    }

    @Override
    public boolean visit(final ValueVisitor visitor) throws IOException {
        return this.forwardVisitAll(new EntryVisitor(){

            @Override
            public boolean visitEntry(long timestamp, double value, byte flags) {
                if ((flags & 4) == 0 && (flags & 8) == 0) {
                    return visitor.value(value, new Date(timestamp), (flags & 1) > 0, (flags & 2) > 0);
                }
                return true;
            }
        });
    }

    private int safeRead(ByteBuffer buffer) throws IOException {
        while (this.channel.read(buffer) > 0 && buffer.hasRemaining()) {
        }
        return buffer.position();
    }

    @Override
    public void forwardCorrect(double value, Date afterDate) throws Exception {
        long startTimestamp = afterDate.getTime();
        long position = this.channel.position();
        try {
            this.channel.position(24L);
            ByteBuffer buffer = ByteBuffer.allocate(17);
            while (this.safeRead(buffer) == 17) {
                buffer.flip();
                double entryValue = buffer.getDouble();
                long entryTimestamp = buffer.getLong();
                byte flags = buffer.get();
                logger.debug("Checking value - flag: {}", (Object)flags);
                if ((flags & 4) == 0 && (flags & 8) == 0 && entryTimestamp > startTimestamp) {
                    logger.info("Rewriting history - delete - timestamp: {}, value: {}", (Object)entryTimestamp, (Object)entryValue);
                    this.channel.position(this.channel.position() - 1L);
                    this.channel.write(ByteBuffer.wrap(new byte[]{(byte)(flags | 8)}));
                }
                buffer.clear();
            }
        }
        finally {
            this.channel.position(position);
            logger.debug("Returned to position: {}", (Object)position);
        }
    }

    @Override
    public void dispose() {
        logger.debug("Closing {}", (Object)this.fileInfo);
        if (this.file == null) {
            return;
        }
        try {
            this.file.close();
            this.file = null;
        }
        catch (IOException e) {
            logger.warn("Failed to close file", (Throwable)e);
        }
    }

    @Override
    public void delete() {
        if (this.file == null) {
            return;
        }
        this.dispose();
        if (!this.fileInfo.exists()) {
            logger.warn("File does not exists?! {}", (Object)this.fileInfo);
        }
        if (!this.fileInfo.delete()) {
            logger.warn("Failed to delete: {}", (Object)this.fileInfo);
        } else {
            logger.info("Deleted file: {}", (Object)this.fileInfo);
        }
    }

    public static DataFileAccessorImpl create(File file, Date startDate, Date endDate) throws Exception {
        logger.debug("Creating new file: {}", (Object)file);
        if (!file.createNewFile()) {
            throw new IllegalStateException(String.format("Unable to create file %s, already exists", file));
        }
        FileOutputStream out = new FileOutputStream(file);
        try {
            FileChannel channel = out.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(100);
            buffer.putInt(4610);
            buffer.putInt(257);
            buffer.putLong(startDate.getTime());
            buffer.putLong(endDate.getTime());
            buffer.flip();
            while (buffer.hasRemaining()) {
                int rc = channel.write(buffer);
                logger.debug("Header written - {} bytes", (Object)rc);
            }
            DataFileAccessorImpl dataFileAccessorImpl = new DataFileAccessorImpl(file);
            return dataFileAccessorImpl;
        }
        finally {
            out.close();
        }
    }

    public static interface EntryVisitor {
        public boolean visitEntry(long var1, double var3, byte var5);
    }
}

