/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.osgi.pool;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.utils.osgi.FilterUtil;
import org.eclipse.scada.utils.osgi.pool.ObjectPool;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectPoolTracker<S> {
    private static final Logger logger = LoggerFactory.getLogger(ObjectPoolTracker.class);
    private final int DEFAULT_PRIORITY = Integer.getInteger("org.eclipse.scada.osgi.objectPool.defaultPriority", 0);
    private final ServiceTracker<ObjectPool<S>, ObjectPool<S>> poolTracker;
    private final Set<ObjectPoolServiceListener<S>> listeners = new HashSet<ObjectPoolServiceListener<S>>();
    private final Map<ObjectPool<S>, Integer> poolMap = new HashMap<ObjectPool<S>, Integer>();

    public ObjectPoolTracker(BundleContext context, Class<? extends S> poolClass) throws InvalidSyntaxException {
        this(context, poolClass.getName());
    }

    public ObjectPoolTracker(final BundleContext context, String poolClass) throws InvalidSyntaxException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("object.pool.class", poolClass);
        Filter filter = FilterUtil.createAndFilter(ObjectPool.class.getName(), parameters);
        this.poolTracker = new ServiceTracker(context, filter, new ServiceTrackerCustomizer<ObjectPool<S>, ObjectPool<S>>(){

            public void removedService(ServiceReference<ObjectPool<S>> reference, ObjectPool<S> service) {
                context.ungetService(reference);
                ObjectPoolTracker.this.removePool(service);
            }

            public void modifiedService(ServiceReference<ObjectPool<S>> reference, ObjectPool<S> service) {
                ObjectPoolTracker.this.modifyPool(service, reference);
            }

            public ObjectPool<S> addingService(ServiceReference<ObjectPool<S>> reference) {
                ObjectPool o = (ObjectPool)context.getService(reference);
                ObjectPoolTracker.this.addPool(o, reference);
                return o;
            }
        });
    }

    protected int getPriority(ServiceReference<ObjectPool<S>> reference) {
        return this.getPriority(reference, this.DEFAULT_PRIORITY);
    }

    protected int getPriority(ServiceReference<ObjectPool<S>> reference, int defaultPriority) {
        Object o = reference.getProperty("service.ranking");
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return defaultPriority;
    }

    protected synchronized void addPool(ObjectPool<S> objectPool, ServiceReference<ObjectPool<S>> reference) {
        logger.debug("Found new pool: {} -> {}", new Object[]{objectPool, reference});
        int priority = this.getPriority(reference);
        this.poolMap.put(objectPool, priority);
        this.fireAdded(objectPool, priority);
    }

    private void fireAdded(ObjectPool<S> objectPool, int priority) {
        for (ObjectPoolServiceListener<S> listener : this.listeners) {
            listener.poolAdded(objectPool, priority);
        }
    }

    protected synchronized void modifyPool(ObjectPool<S> objectPool, ServiceReference<ObjectPool<S>> reference) {
        logger.debug("Pool modified: {} -> {}", new Object[]{objectPool, reference});
        int newPriority = this.getPriority(reference);
        this.poolMap.put(objectPool, newPriority);
        this.fireModified(objectPool, newPriority);
    }

    private void fireModified(ObjectPool<S> objectPool, int newPriority) {
        for (ObjectPoolServiceListener<S> listener : this.listeners) {
            listener.poolModified(objectPool, newPriority);
        }
    }

    protected synchronized void removePool(ObjectPool<S> objectPool) {
        logger.debug("Pool removed: {}", new Object[]{objectPool});
        Integer priority = this.poolMap.remove(objectPool);
        if (priority != null) {
            this.fireRemoved(objectPool);
        }
    }

    private void fireRemoved(ObjectPool<S> objectPool) {
        for (ObjectPoolServiceListener<S> listener : this.listeners) {
            listener.poolRemoved(objectPool);
        }
    }

    public synchronized void open() {
        this.poolTracker.open();
    }

    public synchronized void close() {
        this.poolTracker.close();
    }

    public synchronized void addListener(ObjectPoolServiceListener<S> listener) {
        logger.debug("Adding pool service listener: {}", listener);
        if (this.listeners.add(listener)) {
            for (Map.Entry<ObjectPool<S>, Integer> entry : this.poolMap.entrySet()) {
                logger.debug("Add Announce pool: {}/{}", new Object[]{entry.getKey(), entry.getValue()});
                listener.poolAdded(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ObjectPoolServiceListener<S> listener) {
        HashSet<ObjectPool<S>> pools;
        ObjectPoolTracker objectPoolTracker = this;
        synchronized (objectPoolTracker) {
            if (!this.listeners.remove(listener)) {
                return;
            }
            pools = new HashSet<ObjectPool<S>>(this.poolMap.keySet());
        }
        for (ObjectPool objectPool : pools) {
            listener.poolRemoved(objectPool);
        }
    }

    public static interface ObjectPoolServiceListener<S> {
        public void poolAdded(ObjectPool<S> var1, int var2);

        public void poolRemoved(ObjectPool<S> var1);

        public void poolModified(ObjectPool<S> var1, int var2);
    }
}

