/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.common;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.eclipse.scada.ae.Query;
import org.eclipse.scada.ae.QueryListener;
import org.eclipse.scada.ae.data.QueryState;
import org.eclipse.scada.ae.server.common.SessionImpl;
import org.eclipse.scada.ae.server.storage.Storage;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryImpl
implements Query {
    private static final Logger logger = LoggerFactory.getLogger(QueryImpl.class);
    private boolean disposed = false;
    private final SessionImpl session;
    private final Executor eventExecutor;
    private final QueryListener listener;
    private QueryState currentState;
    private final ExecutorService loadExecutor;
    private final SingleServiceTracker<Storage> tracker;
    private Storage storage;
    private boolean initLoad = true;
    private volatile Future<?> initialLoadJob;
    private volatile Future<?> loadJob;
    private final String queryType;
    private final String queryData;
    private org.eclipse.scada.ae.server.storage.Query query;

    public QueryImpl(BundleContext context, SessionImpl sessionImpl, Executor eventExecutor, ExecutorService loadExecutor, String queryType, String queryData, QueryListener listener) {
        this.session = sessionImpl;
        this.loadExecutor = loadExecutor;
        this.eventExecutor = eventExecutor;
        this.listener = listener;
        this.queryType = queryType;
        this.queryData = queryData;
        this.tracker = new SingleServiceTracker(context, Storage.class, (SingleServiceListener)new SingleServiceListener<Storage>(){

            public void serviceChange(ServiceReference<Storage> reference, Storage service) {
                QueryImpl.this.setStorage(service);
            }
        });
    }

    protected synchronized void setStorage(Storage service) {
        logger.debug("Set storage: {}", (Object)service);
        if (this.disposed) {
            return;
        }
        this.storage = service;
        if (this.storage == null) {
            this.dispose(null);
        } else if (this.initLoad) {
            this.initLoad = false;
            this.loadInitial();
        }
    }

    public synchronized void close() {
        this.dispose(null);
    }

    private void loadInitial() {
        this.initialLoadJob = this.loadExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    QueryImpl.this.query = QueryImpl.this.storage.query(QueryImpl.this.queryData);
                }
                catch (Exception e) {
                    logger.warn("Failed to query storage", (Throwable)e);
                }
                if (QueryImpl.this.query == null) {
                    QueryImpl.this.dispose(null);
                } else {
                    QueryImpl.this.startLoad(Integer.getInteger("org.eclipse.scada.ae.server.common.loadinitial", 500));
                }
            }
        });
    }

    private synchronized void startLoad(final int count) {
        logger.debug("Starting to load {}", (Object)count);
        this.loadJob = this.loadExecutor.submit(new Runnable(){

            @Override
            public void run() {
                QueryImpl.this.performLoad(count);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performLoad(int count) {
        block19: {
            try {
                try {
                    logger.debug("Calling get next: {}...", (Object)count);
                    final List result = this.query.getNext((long)count);
                    logger.debug("Calling get next: {}... complete", (Object)count);
                    this.eventExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            QueryImpl.this.listener.queryData(result);
                        }
                    });
                    if (result.size() < count) {
                        logger.info("Reached end of query: {}", (Object)result.size());
                        this.dispose(null);
                    } else {
                        this.setState(QueryState.CONNECTED, null);
                    }
                }
                catch (Exception e) {
                    logger.warn("Failed to load data", (Throwable)e);
                    QueryImpl queryImpl = this;
                    synchronized (queryImpl) {
                        this.loadJob = null;
                        this.dispose(e);
                    }
                    QueryImpl queryImpl2 = this;
                    synchronized (queryImpl2) {
                        this.loadJob = null;
                        break block19;
                    }
                }
            }
            catch (Throwable throwable) {
                QueryImpl queryImpl = this;
                synchronized (queryImpl) {
                    this.loadJob = null;
                }
                throw throwable;
            }
            QueryImpl queryImpl = this;
            synchronized (queryImpl) {
                this.loadJob = null;
            }
        }
    }

    public synchronized void loadMore(int count) {
        if (this.loadJob != null) {
            return;
        }
        this.setState(QueryState.LOADING, null);
        this.startLoad(count);
    }

    public synchronized void start() {
        this.setState(QueryState.LOADING, null);
        this.tracker.open();
    }

    private void setState(final QueryState state, final Throwable error) {
        if (this.currentState == state) {
            return;
        }
        this.currentState = state;
        this.eventExecutor.execute(new Runnable(){

            @Override
            public void run() {
                QueryImpl.this.listener.queryStateChanged(state, error);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(Throwable error) {
        QueryImpl queryImpl = this;
        synchronized (queryImpl) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
            if (this.initialLoadJob != null) {
                this.initialLoadJob.cancel(true);
                this.initialLoadJob = null;
            }
            if (this.loadJob != null) {
                this.loadJob.cancel(true);
                this.loadJob = null;
            }
            if (this.query != null) {
                this.query.dispose();
                this.query = null;
            }
            this.setState(QueryState.DISCONNECTED, error);
            this.tracker.close();
        }
        this.session.removeQuery(this);
    }

    public synchronized boolean isDisposed() {
        return this.disposed;
    }

    protected void finalize() throws Throwable {
        logger.debug("Disposed query: {}", (Object)this);
        super.finalize();
    }
}

