/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.delta;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.delta.DeltaDataSourceFactory;
import org.eclipse.scada.utils.concurrent.ExportedExecutorService;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private ExecutorService executor;
    private DeltaDataSourceFactory factory;
    private ServiceRegistration<ConfigurationFactory> registration;
    private ObjectPoolTracker<DataSource> dataSourceTracker;

    public void start(BundleContext context) throws Exception {
        this.executor = ExportedExecutorService.newSingleThreadExportedExecutor((String)context.getBundle().getSymbolicName());
        this.dataSourceTracker = new ObjectPoolTracker(context, DataSource.class);
        this.dataSourceTracker.open();
        this.factory = new DeltaDataSourceFactory(context, this.executor, this.dataSourceTracker);
        Hashtable<String, String> properties = new Hashtable<String, String>(3);
        ((Dictionary)properties).put("service.description", "A delta DA data source");
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("factoryId", context.getBundle().getSymbolicName());
        this.registration = context.registerService(ConfigurationFactory.class, (Object)this.factory, properties);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.registration.unregister();
        this.factory.dispose();
        this.executor.shutdown();
    }
}

