/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.exporter.http.server;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.eclipse.scada.hd.exporter.http.HttpExporter;
import org.eclipse.scada.hd.exporter.http.server.internal.JsonServlet;
import org.eclipse.scada.hd.exporter.http.server.internal.LocalHttpExporter;
import org.eclipse.scada.hd.exporter.http.server.internal.RemoteHttpExporter;
import org.eclipse.scada.hd.server.Service;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final String SERVLET_PATH = "/org.eclipse.scada.hd";
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private final SingleServiceListener<HttpService> httpServiceListener = new SingleServiceListener<HttpService>(){

        public void serviceChange(ServiceReference<HttpService> reference, HttpService service) {
            if (Activator.this.httpService != null) {
                Activator.this.httpService.unregister(Activator.SERVLET_PATH);
                Activator.this.httpService.unregister("/media");
                Activator.this.httpService = null;
            }
            Activator.this.httpService = service;
            try {
                Activator.this.httpService.registerServlet(Activator.SERVLET_PATH, (Servlet)Activator.this.jsonServlet, null, null);
                Activator.this.httpService.registerResources("/org.eclipse.scada.hd/ui", "/ui", null);
            }
            catch (Exception e) {
                logger.warn("Failed to handle http service change", (Throwable)e);
            }
        }
    };
    private final SingleServiceListener<HttpExporter> exporterServiceListener = new SingleServiceListener<HttpExporter>(){

        public void serviceChange(ServiceReference<HttpExporter> reference, HttpExporter service) {
            Activator.this.jsonServlet.setExporter(service);
        }
    };
    private final SingleServiceListener<Service> localHdServerServiceListener = new SingleServiceListener<Service>(){

        public void serviceChange(ServiceReference<Service> reference, Service service) {
            if (Activator.this.localHdServerServiceRegistration != null) {
                Activator.this.localHdServerServiceRegistration.unregister();
            }
            if (service != null) {
                Hashtable<String, Integer> props = new Hashtable<String, Integer>();
                ((Dictionary)props).put("service.ranking", 20);
                try {
                    Activator.this.localHttpExporter = new LocalHttpExporter(service);
                    Activator.this.localHdServerServiceRegistration = context.registerService(HttpExporter.class, (Object)Activator.this.localHttpExporter, props);
                }
                catch (Exception e) {
                    logger.warn("Failed to handle service change", (Throwable)e);
                }
            }
        }
    };
    private final JsonServlet jsonServlet = new JsonServlet();
    private static BundleContext context;
    private HttpService httpService = null;
    private LocalHttpExporter localHttpExporter = null;
    private SingleServiceTracker<HttpService> httpServiceTracker;
    private SingleServiceTracker<HttpExporter> exporterServiceTracker;
    private SingleServiceTracker<Service> localHdServerServiceTracker;
    private ServiceRegistration<HttpExporter> localHdServerServiceRegistration;

    public void start(BundleContext context) throws Exception {
        Activator.context = context;
        this.httpServiceTracker = new SingleServiceTracker(context, HttpService.class, this.httpServiceListener);
        this.httpServiceTracker.open();
        this.exporterServiceTracker = new SingleServiceTracker(context, HttpExporter.class, this.exporterServiceListener);
        this.exporterServiceTracker.open();
        this.localHdServerServiceTracker = new SingleServiceTracker(context, Service.class, this.localHdServerServiceListener);
        this.localHdServerServiceTracker.open();
        this.registerRemoteExporter(context);
    }

    private void registerRemoteExporter(BundleContext context) {
        Hashtable<String, Integer> props = new Hashtable<String, Integer>(1);
        ((Dictionary)props).put("service.ranking", 10);
        context.registerService(HttpExporter.class.getName(), (Object)new RemoteHttpExporter(), props);
    }

    public void stop(BundleContext context) throws Exception {
        this.httpServiceTracker.close();
        this.httpServiceTracker = null;
        this.exporterServiceTracker.close();
        this.exporterServiceTracker = null;
        if (this.localHdServerServiceRegistration != null) {
            this.localHdServerServiceRegistration.unregister();
        }
        if (this.localHttpExporter != null) {
            this.localHttpExporter.dispose();
        }
        Activator.context = null;
    }
}

