/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.exporter.ngp;

import org.eclipse.scada.ae.server.Service;
import org.eclipse.scada.ae.server.ngp.Exporter;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private static BundleContext context;
    private SingleServiceTracker<Service> tracker;
    private Exporter exporter;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        this.tracker = new SingleServiceTracker(context, Service.class, (SingleServiceListener)new SingleServiceListener<Service>(){

            public void serviceChange(ServiceReference<Service> reference, Service service) {
                Activator.this.handleServiceChange(service);
            }
        });
        this.tracker.open();
    }

    protected void handleServiceChange(Service service) {
        logger.warn("Exporting new service: {}", (Object)service);
        try {
            if (this.exporter != null) {
                this.exporter.stop();
                this.exporter = null;
            }
            if (service != null) {
                this.exporter = new Exporter(service, ConnectionInformation.fromURI((String)System.getProperty("org.eclipse.scada.ae.server.exporter.ngp.exportUri", "ae:ngp://0.0.0.0:2201")));
                this.exporter.start();
            }
        }
        catch (Exception e) {
            logger.warn("Failed to export hd service", (Throwable)e);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.tracker.close();
        if (this.exporter != null) {
            this.exporter.stop();
            this.exporter = null;
        }
        context = null;
    }
}

