/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.base.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.eclipse.scada.core.Variant;

public final class VariantJsonSerializer
implements JsonSerializer<Variant> {
    public JsonElement serialize(Variant src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == null) {
            return JsonNull.INSTANCE;
        }
        JsonObject result = new JsonObject();
        result.addProperty("type", src.getType().toString());
        switch (src.getType()) {
            case BOOLEAN: {
                result.addProperty("value", src.asBoolean(null));
                break;
            }
            case INT32: 
            case INT64: 
            case DOUBLE: {
                result.addProperty("value", (Number)src.getValue());
                break;
            }
            case STRING: {
                result.addProperty("value", src.asString(null));
                break;
            }
            case NULL: {
                result.add("value", (JsonElement)JsonNull.INSTANCE);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Unknown variant type '%s' encountered", src.getType()));
            }
        }
        return result;
    }
}

