/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.changecounter;

import java.util.List;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.datasource.changecounter.ErrorHandling;
import org.eclipse.scada.da.datasource.data.DataItemValueLight;
import org.eclipse.scada.da.datasource.data.DataItemValueRange;

class ChangeCounterEvaluator {
    ChangeCounterEvaluator() {
    }

    static int handleDelta(List<Variant> values, DataItemValueRange.DataItemValueRangeState valueRangeState, ErrorHandling errorHandling) {
        Double delta = values.get(0).asDouble(null);
        int numOfChanges = 0;
        Double lastValue = valueRangeState.getFirstValue().isError() || !valueRangeState.getFirstValue().hasValue() ? null : valueRangeState.getFirstValue().getValue().asDouble(null);
        for (DataItemValueLight v : valueRangeState.getValues()) {
            if (v.isError() || !v.hasValue()) {
                if (errorHandling == ErrorHandling.ERROR) {
                    throw new IllegalArgumentException("value is invalid");
                }
                if (errorHandling == ErrorHandling.COUNT) {
                    if (lastValue != null) {
                        ++numOfChanges;
                    }
                    lastValue = null;
                    continue;
                }
                if (errorHandling == ErrorHandling.IGNORE) continue;
            }
            Double currentValue = v.getValue().asDouble(null);
            if (lastValue == null) {
                ++numOfChanges;
            } else if (Math.abs(lastValue - currentValue) > delta) {
                ++numOfChanges;
            }
            lastValue = currentValue;
        }
        return numOfChanges;
    }

    static int handleDirection(List<Variant> values, DataItemValueRange.DataItemValueRangeState valueRangeState, ErrorHandling errorHandling) {
        int numOfChanges = 0;
        Double lastValue = valueRangeState.getFirstValue().isError() || !valueRangeState.getFirstValue().hasValue() ? null : valueRangeState.getFirstValue().getValue().asDouble(null);
        int direction = 0;
        for (DataItemValueLight v : valueRangeState.getValues()) {
            if (v.isError() || !v.hasValue()) {
                if (errorHandling == ErrorHandling.ERROR) {
                    throw new IllegalArgumentException("value is invalid");
                }
                if (errorHandling == ErrorHandling.COUNT) {
                    if (lastValue != null) {
                        ++numOfChanges;
                    }
                    lastValue = null;
                    direction = 0;
                    continue;
                }
                if (errorHandling == ErrorHandling.IGNORE) continue;
            }
            Double currentValue = v.getValue().asDouble(null);
            if (lastValue == null) {
                ++numOfChanges;
            } else {
                double delta = currentValue - lastValue;
                if (delta > 0.0) {
                    int newDirection = Long.valueOf(Math.round(delta / Math.abs(delta))).intValue();
                    if (newDirection != direction) {
                        ++numOfChanges;
                    }
                    direction = newDirection;
                }
            }
            lastValue = currentValue;
        }
        return numOfChanges;
    }

    static int handleSet(List<Variant> values, DataItemValueRange.DataItemValueRangeState valueRangeState, ErrorHandling errorHandling) {
        int numOfChanges = 0;
        Variant lastValue = valueRangeState.getFirstValue().isError() ? Variant.NULL : valueRangeState.getFirstValue().getValue();
        for (DataItemValueLight v : valueRangeState.getValues()) {
            if (v.isError()) {
                if (errorHandling == ErrorHandling.ERROR) {
                    throw new IllegalArgumentException("value is invalid");
                }
                if (errorHandling == ErrorHandling.COUNT) {
                    if (lastValue != Variant.NULL) {
                        ++numOfChanges;
                    }
                    lastValue = Variant.NULL;
                    continue;
                }
                if (errorHandling != ErrorHandling.IGNORE) continue;
                continue;
            }
            Variant value = v.getValue();
            if (values.contains(value) && !values.contains(lastValue)) {
                ++numOfChanges;
            } else if (!values.contains(value) && values.contains(lastValue)) {
                ++numOfChanges;
            }
            lastValue = v.getValue();
        }
        return numOfChanges;
    }
}

