/*******************************************************************************
 * Copyright (c) 2013 Jens Reimann and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Jens Reimann - initial API and implementation
 *******************************************************************************/
package org.eclipse.scada.da.exec.configuration.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.scada.da.exec.configuration.util.ConfigurationAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ConfigurationItemProviderAdapterFactory extends ConfigurationAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable
{
    //$NON-NLS-1$

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public static final String copyright = "Copyright (c) 2013 Jens Reimann and others.\nAll rights reserved. This program and the accompanying materials\nare made available under the terms of the Eclipse Public License v1.0\nwhich accompanies this distribution, and is available at\nhttp://www.eclipse.org/legal/epl-v10.html\n\nContributors:\n    Jens Reimann - initial API and implementation"; //$NON-NLS-1$

    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier ();

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object> ();

    /**
     * This constructs an instance.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ConfigurationItemProviderAdapterFactory ()
    {
        supportedTypes.add ( IEditingDomainItemProvider.class );
        supportedTypes.add ( IStructuredItemContentProvider.class );
        supportedTypes.add ( ITreeItemContentProvider.class );
        supportedTypes.add ( IItemLabelProvider.class );
        supportedTypes.add ( IItemPropertySource.class );
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.exec.configuration.ContinuousCommandType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ContinuousCommandTypeItemProvider continuousCommandTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.exec.configuration.ContinuousCommandType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createContinuousCommandTypeAdapter ()
    {
        if ( continuousCommandTypeItemProvider == null )
        {
            continuousCommandTypeItemProvider = new ContinuousCommandTypeItemProvider ( this );
        }

        return continuousCommandTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.exec.configuration.CustomExtractorType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected CustomExtractorTypeItemProvider customExtractorTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.exec.configuration.CustomExtractorType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createCustomExtractorTypeAdapter ()
    {
        if ( customExtractorTypeItemProvider == null )
        {
            customExtractorTypeItemProvider = new CustomExtractorTypeItemProvider ( this );
        }

        return customExtractorTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.exec.configuration.DocumentRoot} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DocumentRootItemProvider documentRootItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.exec.configuration.DocumentRoot}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDocumentRootAdapter ()
    {
        if ( documentRootItemProvider == null )
        {
            documentRootItemProvider = new DocumentRootItemProvider ( this );
        }

        return documentRootItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.exec.configuration.EnvEntryType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EnvEntryTypeItemProvider envEntryTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.exec.configuration.EnvEntryType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createEnvEntryTypeAdapter ()
    {
        if ( envEntryTypeItemProvider == null )
        {
            envEntryTypeItemProvider = new EnvEntryTypeItemProvider ( this );
        }

        return envEntryTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.exec.configuration.FieldType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected FieldTypeItemProvider fieldTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.exec.configuration.FieldType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createFieldTypeAdapter ()
    {
        if ( fieldTypeItemProvider == null )
        {
            fieldTypeItemProvider = new FieldTypeItemProvider ( this );
        }

        return fieldTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.exec.configuration.HiveProcessCommandType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected HiveProcessCommandTypeItemProvider hiveProcessCommandTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.exec.configuration.HiveProcessCommandType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createHiveProcessCommandTypeAdapter ()
    {
        if ( hiveProcessCommandTypeItemProvider == null )
        {
            hiveProcessCommandTypeItemProvider = new HiveProcessCommandTypeItemProvider ( this );
        }

        return hiveProcessCommandTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.exec.configuration.NagiosReturnCodeExtractorType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected NagiosReturnCodeExtractorTypeItemProvider nagiosReturnCodeExtractorTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.exec.configuration.NagiosReturnCodeExtractorType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createNagiosReturnCodeExtractorTypeAdapter ()
    {
        if ( nagiosReturnCodeExtractorTypeItemProvider == null )
        {
            nagiosReturnCodeExtractorTypeItemProvider = new NagiosReturnCodeExtractorTypeItemProvider ( this );
        }

        return nagiosReturnCodeExtractorTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.exec.configuration.PlainStreamExtractorType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected PlainStreamExtractorTypeItemProvider plainStreamExtractorTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.exec.configuration.PlainStreamExtractorType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createPlainStreamExtractorTypeAdapter ()
    {
        if ( plainStreamExtractorTypeItemProvider == null )
        {
            plainStreamExtractorTypeItemProvider = new PlainStreamExtractorTypeItemProvider ( this );
        }

        return plainStreamExtractorTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.exec.configuration.ProcessType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ProcessTypeItemProvider processTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.exec.configuration.ProcessType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createProcessTypeAdapter ()
    {
        if ( processTypeItemProvider == null )
        {
            processTypeItemProvider = new ProcessTypeItemProvider ( this );
        }

        return processTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.exec.configuration.QueueType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected QueueTypeItemProvider queueTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.exec.configuration.QueueType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createQueueTypeAdapter ()
    {
        if ( queueTypeItemProvider == null )
        {
            queueTypeItemProvider = new QueueTypeItemProvider ( this );
        }

        return queueTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.exec.configuration.RegExExtractorType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected RegExExtractorTypeItemProvider regExExtractorTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.exec.configuration.RegExExtractorType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createRegExExtractorTypeAdapter ()
    {
        if ( regExExtractorTypeItemProvider == null )
        {
            regExExtractorTypeItemProvider = new RegExExtractorTypeItemProvider ( this );
        }

        return regExExtractorTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.exec.configuration.ReturnCodeExtractorType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ReturnCodeExtractorTypeItemProvider returnCodeExtractorTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.exec.configuration.ReturnCodeExtractorType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createReturnCodeExtractorTypeAdapter ()
    {
        if ( returnCodeExtractorTypeItemProvider == null )
        {
            returnCodeExtractorTypeItemProvider = new ReturnCodeExtractorTypeItemProvider ( this );
        }

        return returnCodeExtractorTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.exec.configuration.RootType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected RootTypeItemProvider rootTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.exec.configuration.RootType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createRootTypeAdapter ()
    {
        if ( rootTypeItemProvider == null )
        {
            rootTypeItemProvider = new RootTypeItemProvider ( this );
        }

        return rootTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.exec.configuration.SingleCommandType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SingleCommandTypeItemProvider singleCommandTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.exec.configuration.SingleCommandType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSingleCommandTypeAdapter ()
    {
        if ( singleCommandTypeItemProvider == null )
        {
            singleCommandTypeItemProvider = new SingleCommandTypeItemProvider ( this );
        }

        return singleCommandTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.exec.configuration.SplitContinuousCommandType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SplitContinuousCommandTypeItemProvider splitContinuousCommandTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.exec.configuration.SplitContinuousCommandType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSplitContinuousCommandTypeAdapter ()
    {
        if ( splitContinuousCommandTypeItemProvider == null )
        {
            splitContinuousCommandTypeItemProvider = new SplitContinuousCommandTypeItemProvider ( this );
        }

        return splitContinuousCommandTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.exec.configuration.SplitterExtractorType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SplitterExtractorTypeItemProvider splitterExtractorTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.exec.configuration.SplitterExtractorType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSplitterExtractorTypeAdapter ()
    {
        if ( splitterExtractorTypeItemProvider == null )
        {
            splitterExtractorTypeItemProvider = new SplitterExtractorTypeItemProvider ( this );
        }

        return splitterExtractorTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.exec.configuration.SplitterType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SplitterTypeItemProvider splitterTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.exec.configuration.SplitterType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSplitterTypeAdapter ()
    {
        if ( splitterTypeItemProvider == null )
        {
            splitterTypeItemProvider = new SplitterTypeItemProvider ( this );
        }

        return splitterTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.exec.configuration.TriggerCommandType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected TriggerCommandTypeItemProvider triggerCommandTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.exec.configuration.TriggerCommandType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createTriggerCommandTypeAdapter ()
    {
        if ( triggerCommandTypeItemProvider == null )
        {
            triggerCommandTypeItemProvider = new TriggerCommandTypeItemProvider ( this );
        }

        return triggerCommandTypeItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ComposeableAdapterFactory getRootAdapterFactory ()
    {
        return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory ();
    }

    /**
     * This sets the composed adapter factory that contains this factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setParentAdapterFactory ( ComposedAdapterFactory parentAdapterFactory )
    {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean isFactoryForType ( Object type )
    {
        return supportedTypes.contains ( type ) || super.isFactoryForType ( type );
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter adapt ( Notifier notifier, Object type )
    {
        return super.adapt ( notifier, this );
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object adapt ( Object object, Object type )
    {
        if ( isFactoryForType ( type ) )
        {
            Object adapter = super.adapt ( object, type );
            if ( ! ( type instanceof Class<?> ) || ( ( (Class<?>)type ).isInstance ( adapter ) ) )
            {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void addListener ( INotifyChangedListener notifyChangedListener )
    {
        changeNotifier.addListener ( notifyChangedListener );
    }

    /**
     * This removes a listener.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void removeListener ( INotifyChangedListener notifyChangedListener )
    {
        changeNotifier.removeListener ( notifyChangedListener );
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void fireNotifyChanged ( Notification notification )
    {
        changeNotifier.fireNotifyChanged ( notification );

        if ( parentAdapterFactory != null )
        {
            parentAdapterFactory.fireNotifyChanged ( notification );
        }
    }

    /**
     * This disposes all of the item providers created by this factory. 
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void dispose ()
    {
        if ( continuousCommandTypeItemProvider != null )
            continuousCommandTypeItemProvider.dispose ();
        if ( customExtractorTypeItemProvider != null )
            customExtractorTypeItemProvider.dispose ();
        if ( documentRootItemProvider != null )
            documentRootItemProvider.dispose ();
        if ( envEntryTypeItemProvider != null )
            envEntryTypeItemProvider.dispose ();
        if ( fieldTypeItemProvider != null )
            fieldTypeItemProvider.dispose ();
        if ( hiveProcessCommandTypeItemProvider != null )
            hiveProcessCommandTypeItemProvider.dispose ();
        if ( nagiosReturnCodeExtractorTypeItemProvider != null )
            nagiosReturnCodeExtractorTypeItemProvider.dispose ();
        if ( plainStreamExtractorTypeItemProvider != null )
            plainStreamExtractorTypeItemProvider.dispose ();
        if ( processTypeItemProvider != null )
            processTypeItemProvider.dispose ();
        if ( queueTypeItemProvider != null )
            queueTypeItemProvider.dispose ();
        if ( regExExtractorTypeItemProvider != null )
            regExExtractorTypeItemProvider.dispose ();
        if ( returnCodeExtractorTypeItemProvider != null )
            returnCodeExtractorTypeItemProvider.dispose ();
        if ( rootTypeItemProvider != null )
            rootTypeItemProvider.dispose ();
        if ( singleCommandTypeItemProvider != null )
            singleCommandTypeItemProvider.dispose ();
        if ( splitContinuousCommandTypeItemProvider != null )
            splitContinuousCommandTypeItemProvider.dispose ();
        if ( splitterExtractorTypeItemProvider != null )
            splitterExtractorTypeItemProvider.dispose ();
        if ( splitterTypeItemProvider != null )
            splitterTypeItemProvider.dispose ();
        if ( triggerCommandTypeItemProvider != null )
            triggerCommandTypeItemProvider.dispose ();
    }

}
