/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.authn.osgi.cfg.priority;

import java.util.List;
import org.eclipse.scada.sec.AuthenticationException;
import org.eclipse.scada.sec.AuthenticationService;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.sec.authn.CredentialsRequest;
import org.eclipse.scada.sec.callback.Callback;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.concurrent.TransformResultFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProcessCallbacksFuture
extends TransformResultFuture<Callback[], UserInformation> {
    private static final Logger logger = LoggerFactory.getLogger(ProcessCallbacksFuture.class);

    public ProcessCallbacksFuture(NotifyFuture<Callback[]> fromFuture) {
        super(fromFuture);
    }

    protected abstract CredentialsRequest getRequest();

    protected abstract List<AuthenticationService> getServices();

    protected UserInformation transform(Callback[] from) throws Exception {
        logger.debug("Processing reply - callbacks: {}", new Object[]{from});
        return this.processCallbacks(this.getRequest(), this.getServices());
    }

    protected UserInformation processCallbacks(CredentialsRequest request, List<AuthenticationService> services) throws AuthenticationException {
        for (AuthenticationService service : services) {
            UserInformation userInformation = service.authenticate(request);
            if (userInformation == null) continue;
            return userInformation;
        }
        return null;
    }
}

