/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.da.server.exporter.iec60870;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.neoscada.da.server.exporter.iec60870.ChangeModel;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDUAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationEntry;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;

public class BufferingChangeModel
implements ChangeModel {
    private final Context context;
    private final ScheduledExecutorService executor;
    private final long flushDelay;
    private Map<ASDUAddress, Map<InformationObjectAddress, Value<?>>> cache = new HashMap();
    private ScheduledFuture<?> future;

    public BufferingChangeModel(Context context, ScheduledExecutorService executor, long flushDelay) {
        this.context = context;
        this.executor = executor;
        this.flushDelay = flushDelay;
    }

    @Override
    public synchronized void notifyChange(ASDUAddress asduAddress, InformationObjectAddress informationObjectAddress, Value<?> value) {
        Map<InformationObjectAddress, Value<?>> asduCache = this.cache.get(asduAddress);
        if (asduCache == null) {
            asduCache = new HashMap();
            this.cache.put(asduAddress, asduCache);
        }
        if (asduCache.containsKey(value)) {
            final Map<ASDUAddress, Map<InformationObjectAddress, Value<?>>> cache = this.cache;
            this.cache = new HashMap();
            asduCache = new HashMap();
            this.cache.put(asduAddress, asduCache);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    BufferingChangeModel.this.performFlush(cache);
                }
            });
        }
        asduCache.put(informationObjectAddress, value);
        this.triggerFlush();
    }

    private synchronized void triggerFlush() {
        if (this.future != null) {
            return;
        }
        this.future = this.executor.schedule(new Runnable(){

            @Override
            public void run() {
                BufferingChangeModel.this.flush();
            }
        }, this.flushDelay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        Map<ASDUAddress, Map<InformationObjectAddress, Value<?>>> cache;
        BufferingChangeModel bufferingChangeModel = this;
        synchronized (bufferingChangeModel) {
            if (this.future == null) {
                return;
            }
            cache = this.cache;
            this.cache = new HashMap();
            this.future = null;
        }
        this.performFlush(cache);
    }

    private void performFlush(Map<ASDUAddress, Map<InformationObjectAddress, Value<?>>> cache) {
        for (Map.Entry<ASDUAddress, Map<InformationObjectAddress, Value<?>>> entry : cache.entrySet()) {
            List<InformationEntry<?>> booleans = null;
            List<InformationEntry<?>> floats = null;
            for (Map.Entry<InformationObjectAddress, Value<?>> valueEntry : entry.getValue().entrySet()) {
                InformationObjectAddress ioa = valueEntry.getKey();
                Value<?> value = valueEntry.getValue();
                if (value.getValue() instanceof Boolean) {
                    booleans = this.add(booleans, ioa, value);
                    continue;
                }
                if (!(value.getValue() instanceof Float)) continue;
                floats = this.add(floats, ioa, value);
            }
            if (booleans != null) {
                this.context.notifyBoolean(entry.getKey(), booleans);
            }
            if (floats == null) continue;
            this.context.notifyFloat(entry.getKey(), floats);
        }
    }

    private <T> List<InformationEntry<T>> add(List<InformationEntry<T>> values, InformationObjectAddress ioa, Value<T> value) {
        if (values == null) {
            values = new LinkedList<InformationEntry<T>>();
        }
        values.add(new InformationEntry(ioa, value));
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        BufferingChangeModel bufferingChangeModel = this;
        synchronized (bufferingChangeModel) {
            if (this.future != null) {
                this.future.cancel(false);
                this.future = null;
            }
        }
    }

    public static interface Context {
        public void notifyBoolean(ASDUAddress var1, List<InformationEntry<Boolean>> var2);

        public void notifyFloat(ASDUAddress var1, List<InformationEntry<Float>> var2);
    }
}

