/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.da.server.exporter.iec60870;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.neoscada.core.common.iec60870.Configurations;
import org.eclipse.neoscada.da.server.exporter.iec60870.MappingEntry;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.server.data.DataModuleOptions;
import org.eclipse.scada.ca.ConfigurationDataHelper;

public class ExportConfiguration {
    private short port = (short)2404;
    private Long spontaneousBufferWindow;
    private ProtocolOptions protocolOptions;
    private DataModuleOptions dataModuleOptions;
    private Set<MappingEntry> entries = new HashSet<MappingEntry>();
    private Properties hiveProperties = new Properties();

    public void setDataModuleOptions(DataModuleOptions dataModuleOptions) {
        this.dataModuleOptions = dataModuleOptions;
    }

    public DataModuleOptions getDataModuleOptions() {
        return this.dataModuleOptions;
    }

    public void setHiveProperties(Properties hiveProperties) {
        this.hiveProperties = hiveProperties;
    }

    public Properties getHiveProperties() {
        return this.hiveProperties;
    }

    public void setEntries(Set<MappingEntry> entries) {
        this.entries = entries;
    }

    public Set<MappingEntry> getEntries() {
        return this.entries;
    }

    public void setProtocolOptions(ProtocolOptions options) {
        this.protocolOptions = options;
    }

    public ProtocolOptions getProtocolOptions() {
        return this.protocolOptions;
    }

    public short getPort() {
        return this.port;
    }

    public void setPort(short port) {
        this.port = port;
    }

    public void setSpontaneousBufferWindow(Long spontaneousBufferWindow) {
        this.spontaneousBufferWindow = spontaneousBufferWindow;
    }

    public Long getSpontaneousBufferWindow() {
        return this.spontaneousBufferWindow;
    }

    public static ExportConfiguration parse(Map<String, String> parameters) {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        ExportConfiguration result = new ExportConfiguration();
        result.setPort((short)cfg.getInteger("port", 2404));
        result.setSpontaneousBufferWindow(cfg.getLong("spontaneousBufferWindow"));
        ProtocolOptions.Builder optionsBuilder = Configurations.parseProtocolOptions((ConfigurationDataHelper)cfg);
        result.setProtocolOptions(optionsBuilder.build());
        DataModuleOptions.Builder dataModuleOptions = new DataModuleOptions.Builder();
        dataModuleOptions.setBackgroundScanPeriod(cfg.getInteger("backgroundScanPeriod", 60000));
        dataModuleOptions.setSpontaneousDuplicates(cfg.getInteger("spontaneousItemBuffer", 100));
        dataModuleOptions.setFloatsWithTimestamp(cfg.getBoolean("withTimestamp.float", true));
        dataModuleOptions.setBooleansWithTimestamp(cfg.getBoolean("withTimestamp.boolean", true));
        result.setDataModuleOptions(dataModuleOptions.build());
        HashSet<MappingEntry> entries = new HashSet<MappingEntry>();
        for (Map.Entry entry : cfg.getPrefixed("entry.").entrySet()) {
            entries.add(ExportConfiguration.createEntry((String)entry.getKey(), (String)entry.getValue()));
        }
        result.setEntries(entries);
        result.setHiveProperties(cfg.getPrefixedProperties("hive."));
        return result;
    }

    private static MappingEntry createEntry(String key, String value) {
        String itemId;
        MappingEntry.ValueType type;
        String[] addr = key.split("\\.");
        String[] item = value.split("#", 2);
        if (addr.length != 2) {
            throw new IllegalArgumentException(String.format("Address must be of the format '<asduAddress>.<informationObjectAddress>': '%s'", key));
        }
        int asduAddress = ExportConfiguration.convertAddress(addr[0]);
        int infoAddress = ExportConfiguration.convertAddress(addr[1]);
        if (item.length > 1) {
            type = MappingEntry.ValueType.valueOf(item[0]);
            itemId = item[1];
        } else {
            type = null;
            itemId = item[0];
        }
        return new MappingEntry(itemId, asduAddress, infoAddress, type);
    }

    private static int convertAddress(String string) {
        String[] toks = string.split("[\\s-]");
        int value = 0;
        String[] stringArray = toks;
        int n = toks.length;
        int n2 = 0;
        while (n2 < n) {
            String tok = stringArray[n2];
            int v = Integer.parseInt(tok);
            value <<= 8;
            value |= v;
            ++n2;
        }
        return value;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.dataModuleOptions == null ? 0 : this.dataModuleOptions.hashCode());
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        result = 31 * result + (this.hiveProperties == null ? 0 : this.hiveProperties.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.protocolOptions == null ? 0 : this.protocolOptions.hashCode());
        result = 31 * result + (this.spontaneousBufferWindow == null ? 0 : this.spontaneousBufferWindow.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExportConfiguration other = (ExportConfiguration)obj;
        if (this.dataModuleOptions == null ? other.dataModuleOptions != null : !this.dataModuleOptions.equals((Object)other.dataModuleOptions)) {
            return false;
        }
        if (this.entries == null ? other.entries != null : !this.entries.equals(other.entries)) {
            return false;
        }
        if (this.hiveProperties == null ? other.hiveProperties != null : !this.hiveProperties.equals(other.hiveProperties)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.protocolOptions == null ? other.protocolOptions != null : !this.protocolOptions.equals((Object)other.protocolOptions)) {
            return false;
        }
        return !(this.spontaneousBufferWindow == null ? other.spontaneousBufferWindow != null : !this.spontaneousBufferWindow.equals(other.spontaneousBufferWindow));
    }
}

