/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.da.server.exporter.iec60870;

import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.neoscada.da.server.exporter.iec60870.DataModelImpl;
import org.eclipse.neoscada.da.server.exporter.iec60870.ExportConfiguration;
import org.eclipse.neoscada.da.server.exporter.iec60870.InformationBean;
import org.eclipse.neoscada.protocol.iec60870.server.Server;
import org.eclipse.neoscada.protocol.iec60870.server.data.DataModel;
import org.eclipse.neoscada.protocol.iec60870.server.data.DataModule;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.exporter.ObjectExporter;
import org.eclipse.scada.da.server.common.item.factory.ItemFactory;
import org.eclipse.scada.da.server.common.osgi.factory.ObjectPoolDataItemFactory;
import org.eclipse.scada.da.server.exporter.common.HiveSource;
import org.eclipse.scada.utils.osgi.pool.ManageableObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IecExport {
    private static final Logger logger = LoggerFactory.getLogger(IecExport.class);
    private ExportConfiguration configuration;
    private Server server;
    private DataModule dataModule;
    private final InformationBean info = new InformationBean();
    private final ObjectExporter exporter;
    private final HiveSource hiveSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IecExport(String id, Map<String, String> parameters, ScheduledExecutorService executor, ManageableObjectPool<DataItem> itemObjectPool, HiveSource hiveSource) {
        this.hiveSource = hiveSource;
        ObjectPoolDataItemFactory itemFactory = new ObjectPoolDataItemFactory((Executor)executor, itemObjectPool, String.format("org.eclipse.neoscada.da.server.exporter.iec60870.export.%s.information.", id));
        this.exporter = new ObjectExporter((ItemFactory)itemFactory, true, true);
        this.exporter.attachTarget((Object)this.info);
        IecExport iecExport = this;
        synchronized (iecExport) {
            this.update(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        IecExport iecExport = this;
        synchronized (iecExport) {
            this.disposeServer();
            this.disposeDataModel();
        }
        if (this.exporter != null) {
            this.exporter.dispose();
        }
    }

    public synchronized void update(Map<String, String> parameters) {
        ExportConfiguration cfg = ExportConfiguration.parse(parameters);
        if (this.configuration == null || !this.configuration.equals(cfg)) {
            this.applyConfiguration(cfg);
        }
    }

    private synchronized void applyConfiguration(ExportConfiguration cfg) {
        this.configuration = cfg;
        this.info.setConfigured(this.configuration != null);
        this.checkAndCreate();
    }

    private void checkAndCreate() {
        this.disposeServer();
        this.disposeDataModel();
        if (this.configuration != null) {
            this.dataModule = new DataModule(this.configuration.getDataModuleOptions(), (DataModel)new DataModelImpl(this.hiveSource, this.configuration.getEntries(), this.configuration.getHiveProperties(), this.info, this.configuration.getSpontaneousBufferWindow()));
            this.info.setItems(this.configuration.getEntries().size());
            LinkedList<DataModule> modules = new LinkedList<DataModule>();
            modules.add(this.dataModule);
            this.server = new Server(this.configuration.getPort(), this.configuration.getProtocolOptions(), modules);
        }
        this.info.setHasDataModule(this.dataModule != null);
        this.info.setHasServer(this.server != null);
    }

    private void disposeDataModel() {
        if (this.dataModule != null) {
            this.dataModule.dispose();
            this.dataModule = null;
        }
        this.info.setItems(0);
        this.info.setHasDataModule(this.dataModule != null);
    }

    private void disposeServer() {
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (Exception e) {
                logger.warn("Failed to close server", (Throwable)e);
            }
            this.server = null;
        }
        this.info.setHasServer(this.server != null);
    }
}

