/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.da.server.exporter.iec60870;

public class MappingEntry {
    private final String itemId;
    private final int asduAddress;
    private final int address;
    private final ValueType valueType;

    public MappingEntry(String itemId, int asduAddress, int address, ValueType valueType) {
        this.itemId = itemId;
        this.asduAddress = asduAddress;
        this.address = address;
        this.valueType = valueType;
    }

    public String getItemId() {
        return this.itemId;
    }

    public int getAddress() {
        return this.address;
    }

    public int getAsduAddress() {
        return this.asduAddress;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public String toString() {
        return String.format("[%s/%s -> %s : %s]", new Object[]{this.asduAddress, this.address, this.itemId, this.valueType});
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.address;
        result = 31 * result + this.asduAddress;
        result = 31 * result + (this.itemId == null ? 0 : this.itemId.hashCode());
        result = 31 * result + (this.valueType == null ? 0 : this.valueType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MappingEntry other = (MappingEntry)obj;
        if (this.address != other.address) {
            return false;
        }
        if (this.asduAddress != other.asduAddress) {
            return false;
        }
        if (this.itemId == null ? other.itemId != null : !this.itemId.equals(other.itemId)) {
            return false;
        }
        return this.valueType == other.valueType;
    }

    public static enum ValueType {
        FLOAT,
        BOOLEAN;

    }
}

