/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.da.server.iec60870;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.neoscada.da.server.iec60870.ClientState;
import org.eclipse.neoscada.da.server.iec60870.ConnectionConfiguration;
import org.eclipse.neoscada.da.server.iec60870.Hive;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.SetPointCommandScaledValue;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.SetPointCommandShortFloatingPoint;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.SingleCommand;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDUAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Cause;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.CauseOfTransmission;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.DoublePoint;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.StandardCause;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;
import org.eclipse.neoscada.protocol.iec60870.client.AutoConnectClient;
import org.eclipse.neoscada.protocol.iec60870.client.ClientModule;
import org.eclipse.neoscada.protocol.iec60870.client.data.DataHandler;
import org.eclipse.neoscada.protocol.iec60870.client.data.DataListener;
import org.eclipse.neoscada.protocol.iec60870.client.data.DataModule;
import org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions;
import org.eclipse.neoscada.protocol.iec60870.client.data.DataProcessor;
import org.eclipse.scada.core.NotConvertableException;
import org.eclipse.scada.core.NullValueException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.core.DataItemInformation;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.data.IODirection;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.browser.common.query.AttributeNameProvider;
import org.eclipse.scada.da.server.browser.common.query.GroupFolder;
import org.eclipse.scada.da.server.browser.common.query.GroupProvider;
import org.eclipse.scada.da.server.browser.common.query.IDNameProvider;
import org.eclipse.scada.da.server.browser.common.query.InvisibleStorage;
import org.eclipse.scada.da.server.browser.common.query.ItemDescriptor;
import org.eclipse.scada.da.server.browser.common.query.ItemStorage;
import org.eclipse.scada.da.server.browser.common.query.NameProvider;
import org.eclipse.scada.da.server.browser.common.query.SplitGroupProvider;
import org.eclipse.scada.da.server.browser.common.query.SplitNameProvider;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.DataItemInformationBase;
import org.eclipse.scada.da.server.common.chain.ChainItem;
import org.eclipse.scada.da.server.common.chain.DataItemInputOutputChained;
import org.eclipse.scada.da.server.common.chain.item.SumErrorChainItem;
import org.eclipse.scada.da.server.common.exporter.ObjectExporter;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.eclipse.scada.da.server.common.item.factory.DefaultChainItemFactory;
import org.eclipse.scada.da.server.common.item.factory.ItemFactory;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection {
    private static final Logger logger = LoggerFactory.getLogger(Connection.class);
    private final DataHandler handler;
    private final AutoConnectClient client;
    private final FolderCommon folder;
    private final AtomicBoolean disposed = new AtomicBoolean(false);
    private final Hive hive;
    private final DefaultChainItemFactory stateFactory;
    private final GroupFolder dataFolder;
    private final InvisibleStorage storage;
    private final ObjectExporter clientExporter;
    private final ClientState clientState;
    private final AutoConnectClient.StateListener clientListener = new AutoConnectClient.StateListener(){

        public void stateChanged(AutoConnectClient.State state, Throwable e) {
            Connection.this.handleStateChanged(state, e);
        }
    };
    private final AutoConnectClient.ModulesFactory modulesFactory;
    private final DataListener dataListener = new DataListener(){

        public void started() {
            Connection.this.setStarted(true);
        }

        public void update(ASDUAddress commonAddress, InformationObjectAddress objectAddress, Value<?> value) {
            Connection.this.handleDataUpdate(commonAddress, objectAddress, value);
        }

        public void disconnected() {
            Connection.this.handleDisconnected();
        }
    };
    private final ProtocolOptions protocolOptions;
    private final Executor executor;
    private final Map<String, DataItemInputOutputChained> itemCache = new HashMap<String, DataItemInputOutputChained>();
    private final String id;
    private final DataModuleOptions dataModuleOptions;

    public Connection(String id, Hive hive, Executor executor, ConnectionConfiguration configuration) {
        this.hive = hive;
        this.id = id;
        this.executor = executor;
        this.dataModuleOptions = configuration.getDataModuleOptions();
        this.handler = new DataProcessor(executor, this.dataListener);
        final DataModule dataModule = new DataModule(this.handler, this.dataModuleOptions);
        this.protocolOptions = configuration.getProtocolOptions();
        this.folder = new FolderCommon();
        hive.getRootFolder().add(id, (Folder)this.folder, null);
        this.stateFactory = new DefaultChainItemFactory((HiveCommon)hive, this.folder, String.valueOf(id) + ".state", "state");
        this.dataFolder = new GroupFolder((GroupProvider)new SplitGroupProvider((NameProvider)new AttributeNameProvider("iec.60870.address"), "\\.", 0, 1), (NameProvider)new SplitNameProvider((NameProvider)new IDNameProvider(), "\\.", -2, 0, "."));
        this.storage = new InvisibleStorage();
        this.storage.addChild((ItemStorage)this.dataFolder);
        this.folder.add("data", (Folder)this.dataFolder, null);
        this.clientExporter = new ObjectExporter((ItemFactory)this.stateFactory.createSubFolderFactory("client"));
        this.clientState = new ClientState(this);
        this.clientExporter.attachTarget((Object)this.clientState);
        this.modulesFactory = new AutoConnectClient.ModulesFactory(){

            public List<ClientModule> createModules() {
                return Collections.singletonList(dataModule);
            }
        };
        this.client = new AutoConnectClient(configuration.getHost(), configuration.getPort(), configuration.getProtocolOptions(), this.modulesFactory, this.clientListener);
    }

    protected void setStarted(boolean value) {
        this.clientState.setDataStarted(value);
    }

    protected synchronized void handleDisconnected() {
        this.setStarted(false);
        this.storage.clear();
        for (DataItem dataItem : this.itemCache.values()) {
            this.hive.unregisterItem(dataItem);
        }
        this.itemCache.clear();
    }

    protected void handleDataUpdate(ASDUAddress commonAddress, InformationObjectAddress objectAddress, Value<?> value) {
        logger.trace("data update - {}-{} = {}", new Object[]{commonAddress, objectAddress, value});
        DataItemInputOutputChained item = this.getItem(commonAddress, objectAddress);
        this.updateItem(item, value);
    }

    private void updateItem(DataItemInputOutputChained item, Value<?> value) {
        Variant variant = this.convertValue(value);
        Object o = value.getValue();
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        attributes.put("timestamp", Variant.valueOf((long)value.getTimestamp()));
        if (o != null) {
            attributes.put("iec.data.type", Variant.valueOf(o.getClass()));
        }
        if (value.isOverflow()) {
            attributes.put("overflow.error", Variant.TRUE);
        }
        if (value.getQualityInformation().isSubstituted()) {
            attributes.put("manual", Variant.TRUE);
        }
        if (!value.getQualityInformation().isValid()) {
            attributes.put("iec60870.data.error", Variant.TRUE);
        }
        if (value.getQualityInformation().isBlocked()) {
            attributes.put("blocked", Variant.TRUE);
        }
        if (!value.getQualityInformation().isTopical()) {
            attributes.put("iec60870.topical.error", Variant.TRUE);
        }
        item.updateData(variant, attributes, AttributeMode.SET);
    }

    private Variant convertValue(Value<?> value) {
        Object o = value.getValue();
        if (o instanceof DoublePoint) {
            DoublePoint dp = (DoublePoint)o;
            switch (dp) {
                case OFF: {
                    return Variant.FALSE;
                }
                case ON: {
                    return Variant.TRUE;
                }
            }
            return Variant.NULL;
        }
        return Variant.valueOf((Object)value.getValue());
    }

    private synchronized DataItemInputOutputChained getItem(ASDUAddress commonAddress, InformationObjectAddress objectAddress) {
        String localId = this.makeLocalId(commonAddress, objectAddress);
        DataItemInputOutputChained item = this.itemCache.get(localId);
        if (item == null) {
            return this.createItem(localId, commonAddress, objectAddress);
        }
        return item;
    }

    private DataItemInputOutputChained createItem(String localId, final ASDUAddress commonAddress, final InformationObjectAddress objectAddress) {
        String id = String.valueOf(this.id) + ".data." + localId;
        DataItemInformationBase di = new DataItemInformationBase(id, EnumSet.of(IODirection.INPUT, IODirection.OUTPUT));
        DataItemInputOutputChained item = new DataItemInputOutputChained((DataItemInformation)di, this.executor){

            protected NotifyFuture<WriteResult> startWriteCalculatedValue(Variant value, OperationParameters operationParameters) {
                return Connection.this.handleStartWriteValue(commonAddress, objectAddress, value, operationParameters);
            }
        };
        item.addChainElement(IODirection.INPUT, (ChainItem)new SumErrorChainItem());
        this.itemCache.put(localId, item);
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        attributes.put("iec.60870.address", Variant.valueOf((Object)localId));
        this.hive.registerItem((DataItem)item);
        this.storage.added(new ItemDescriptor((DataItem)item, attributes));
        return item;
    }

    protected NotifyFuture<WriteResult> handleStartWriteValue(ASDUAddress commonAddress, InformationObjectAddress objectAddress, Variant value, OperationParameters operationParameters) {
        Object command = this.makeCommand(commonAddress, objectAddress, value);
        if (command == null) {
            return new InstantErrorFuture((Throwable)new IllegalArgumentException(String.format("Unable to write value: %s", value)));
        }
        boolean didWrite = this.client.writeCommand(command);
        if (didWrite) {
            return new InstantFuture((Object)WriteResult.OK);
        }
        return new InstantErrorFuture((Throwable)new IllegalStateException("Client is not connected"));
    }

    private Object makeCommand(ASDUAddress commonAddress, InformationObjectAddress objectAddress, Variant value) {
        if (value == null) {
            return null;
        }
        Byte csa = this.dataModuleOptions.getCauseSourceAddress();
        if (csa == null) {
            csa = 0;
        }
        ASDUHeader header = new ASDUHeader(new CauseOfTransmission((Cause)StandardCause.ACTIVATED, csa), commonAddress);
        try {
            switch (value.getType()) {
                case BOOLEAN: {
                    return new SingleCommand(header, objectAddress, value.asBoolean());
                }
                case DOUBLE: 
                case STRING: {
                    return new SetPointCommandShortFloatingPoint(header, objectAddress, (float)value.asDouble());
                }
                case INT32: 
                case INT64: {
                    return new SetPointCommandScaledValue(header, objectAddress, (short)value.asInteger());
                }
            }
            return null;
        }
        catch (NotConvertableException | NullValueException throwable) {
            return null;
        }
    }

    public FullAddress parseFullAddress(String address) {
        try {
            LinkedList<Integer> segs = new LinkedList<Integer>();
            String[] stringArray = address.split("\\.");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String tok = stringArray[n2];
                segs.add(Integer.parseInt(tok));
                ++n2;
            }
            FullAddress result = new FullAddress();
            switch (this.protocolOptions.getAdsuAddressType()) {
                case SIZE_1: {
                    result.commonAddress = ASDUAddress.fromArray((int[])new int[]{(Integer)segs.poll()});
                    break;
                }
                case SIZE_2: {
                    result.commonAddress = ASDUAddress.fromArray((int[])new int[]{(Integer)segs.poll(), (Integer)segs.poll()});
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("ASDU address size type %s unkown", this.protocolOptions.getAdsuAddressType()));
                }
            }
            switch (this.protocolOptions.getInformationObjectAddressType()) {
                case SIZE_1: {
                    result.objectAddress = InformationObjectAddress.fromArray((int[])new int[]{(Integer)segs.poll()});
                    break;
                }
                case SIZE_2: {
                    result.objectAddress = InformationObjectAddress.fromArray((int[])new int[]{(Integer)segs.poll(), (Integer)segs.poll()});
                    break;
                }
                case SIZE_3: {
                    result.objectAddress = InformationObjectAddress.fromArray((int[])new int[]{(Integer)segs.poll(), (Integer)segs.poll(), (Integer)segs.poll()});
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Information object address size type %s unkown", this.protocolOptions.getInformationObjectAddressType()));
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid IEC address for this configuration", address), e);
        }
    }

    private String makeLocalId(ASDUAddress commonAddress, InformationObjectAddress objectAddress) {
        int a;
        StringBuilder sb = new StringBuilder();
        switch (this.protocolOptions.getAdsuAddressType()) {
            case SIZE_1: {
                sb.append(String.format("%d", commonAddress.getAddress() & 0xFF));
                break;
            }
            default: {
                a = commonAddress.getAddress();
                sb.append(String.format("%d.%d", a >> 8 & 0xFF, a & 0xFF));
            }
        }
        sb.append('.');
        switch (this.protocolOptions.getInformationObjectAddressType()) {
            case SIZE_1: {
                sb.append(String.format("%d", objectAddress.getAddress() & 0xFF));
                break;
            }
            case SIZE_2: {
                a = objectAddress.getAddress();
                sb.append(String.format("%d.%d", a >> 8 & 0xFF, a & 0xFF));
                break;
            }
            default: {
                a = objectAddress.getAddress();
                sb.append(String.format("%d.%d.%d", a >> 16 & 0xFF, a >> 8 & 0xFF, a & 0xFF));
            }
        }
        return sb.toString();
    }

    protected void handleStateChanged(AutoConnectClient.State state, Throwable e) {
        logger.info("Connection state changed: {}", (Object)state);
        this.clientState.setConnectionState("" + state);
    }

    public void dispose() {
        if (!this.disposed.compareAndSet(false, true)) {
            return;
        }
        this.stateFactory.dispose();
        this.hive.getRootFolder().remove((Folder)this.folder);
        this.client.close();
    }

    public void reconnect() {
        this.client.reconnect();
    }

    public static class FullAddress {
        ASDUAddress commonAddress;
        InformationObjectAddress objectAddress;
    }
}

