/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.presentation;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scada.configuration.component.Component;
import org.eclipse.scada.configuration.component.ComponentFactory;
import org.eclipse.scada.configuration.component.ComponentReferenceInputDefinition;
import org.eclipse.scada.configuration.component.ExternalValue;
import org.eclipse.scada.configuration.component.SingleValue;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.da.ui.connection.dnd.ItemTransfer;
import org.eclipse.scada.ui.utils.SelectionHelper;
import org.eclipse.swt.dnd.DropTargetEvent;

public class DropAdapterExtension
extends EditingDomainViewerDropAdapter {
    public DropAdapterExtension(EditingDomain domain, Viewer viewer) {
        super(domain, viewer);
    }

    protected Collection<?> getDragSource(DropTargetEvent event) {
        ItemTransfer itemTransfer = ItemTransfer.getInstance();
        if (itemTransfer.isSupportedType(event.currentDataType)) {
            if (IS_MOTIF) {
                return null;
            }
            Object object = itemTransfer.nativeToJava(event.currentDataType);
            return object == null ? null : this.extractDragSource(object);
        }
        return super.getDragSource(event);
    }

    protected Collection<?> extractDragSource(Object object) {
        if (object instanceof Item[]) {
            LinkedList<ExternalValue> result = new LinkedList<ExternalValue>();
            Item[] itemArray = (Item[])object;
            int n = itemArray.length;
            int n2 = 0;
            while (n2 < n) {
                Item item = itemArray[n2];
                ExternalValue v = ComponentFactory.eINSTANCE.createExternalValue();
                v.setName(item.getId());
                v.setSourceName(item.getId());
                result.add(v);
                ++n2;
            }
            return result;
        }
        if (this.originalOperation != 4) {
            return super.extractDragSource(object);
        }
        if (object instanceof ISelection) {
            List list = SelectionHelper.list((ISelection)((ISelection)object), (SelectionHelper.ListMode)SelectionHelper.ListMode.NONE, Component.class);
            this.originalOperation = 2;
            if (list != null && !list.isEmpty()) {
                LinkedList<ComponentReferenceInputDefinition> result = new LinkedList<ComponentReferenceInputDefinition>();
                for (Component c : list) {
                    ComponentReferenceInputDefinition ref = ComponentFactory.eINSTANCE.createComponentReferenceInputDefinition();
                    ref.setComponent(c);
                    if (c instanceof SingleValue) {
                        ref.getLocalTag().add((Object)((SingleValue)c).getName());
                    }
                    result.add(ref);
                }
                return result;
            }
        }
        return super.extractDragSource(object);
    }
}

