/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.utils.password;

import java.nio.CharBuffer;
import org.eclipse.scada.sec.utils.password.PasswordDigestCodec;

public class HexCodec
implements PasswordDigestCodec {
    private final boolean uppercase;

    public HexCodec() {
        this(true);
    }

    public HexCodec(boolean uppercase) {
        this.uppercase = uppercase;
    }

    @Override
    public byte[] decode(String data) {
        int len = data.length();
        byte[] result = new byte[len / 2 + len % 2];
        CharBuffer cb = CharBuffer.wrap(data);
        int i = 0;
        while (cb.hasRemaining()) {
            if (cb.remaining() > 1) {
                result[i] = (byte)(0xFF & Integer.parseInt(new String(new char[]{cb.get(), cb.get()}), 16));
                ++i;
                continue;
            }
            result[i] = (byte)(0xFF & Integer.parseInt(new String(new char[]{cb.get()}), 16));
        }
        return result;
    }

    @Override
    public String encode(byte[] data) {
        StringBuffer sb = new StringBuffer();
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format("%02x", b));
            ++n2;
        }
        if (this.uppercase) {
            return sb.toString().toUpperCase();
        }
        return sb.toString();
    }
}

