/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu;

import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.MessageCodec;

public class ReflectionMessageCodec<T>
implements MessageCodec {
    private final MethodHandle parseMethod;
    private final MethodHandle encodeMethod;

    public ReflectionMessageCodec(Class<T> clazz, MethodHandle parseMethod, MethodHandle encodeMethod) {
        this.parseMethod = parseMethod;
        this.encodeMethod = encodeMethod;
    }

    public T parse(ProtocolOptions options, byte length, ASDUHeader header, ByteBuf data) {
        try {
            return (T)this.parseMethod.invoke(options, length, header, data);
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to parse message", e);
        }
    }

    @Override
    public void encode(ProtocolOptions options, Object msg, ByteBuf out) {
        try {
            this.encodeMethod.bindTo(msg).invoke(options, out);
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to encode message", e);
        }
    }
}

