/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.EncodeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDU;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationStructure;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.TypeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;

@ASDU(id=13, name="M_ME_NC_1", informationStructure=InformationStructure.SEQUENCE)
public class MeasuredValueShortFloatingPointSequence
extends AbstractMessage {
    private final InformationObjectAddress startAddress;
    private final List<Value<Float>> values;

    private MeasuredValueShortFloatingPointSequence(ASDUHeader header, InformationObjectAddress startAddress, List<Value<Float>> values) {
        super(header);
        this.startAddress = startAddress;
        this.values = values;
    }

    public List<Value<Float>> getValues() {
        return this.values;
    }

    public InformationObjectAddress getStartAddress() {
        return this.startAddress;
    }

    public static MeasuredValueShortFloatingPointSequence parse(ProtocolOptions options, byte length, ASDUHeader header, ByteBuf data) {
        InformationObjectAddress startAddress = InformationObjectAddress.parse(options, data);
        ArrayList<Value<Float>> values = new ArrayList<Value<Float>>(length);
        int i = 0;
        while (i < length) {
            values.add(TypeHelper.parseFloatValue(options, data, false));
            ++i;
        }
        return new MeasuredValueShortFloatingPointSequence(header, startAddress, values);
    }

    @Override
    public void encode(ProtocolOptions options, ByteBuf out) {
        EncodeHelper.encodeHeader(this, options, this.values.size(), this.header, out);
        this.startAddress.encode(options, out);
        for (Value<Float> value : this.values) {
            TypeHelper.encodeFloatValue(options, out, value, false);
        }
    }

    public static MeasuredValueShortFloatingPointSequence create(InformationObjectAddress startAddress, ASDUHeader header, Value<Float> value) {
        return MeasuredValueShortFloatingPointSequence.createInternal(startAddress, header, Collections.singletonList(value));
    }

    public static MeasuredValueShortFloatingPointSequence create(InformationObjectAddress startAddress, ASDUHeader header, List<Value<Float>> values) {
        if (values.size() > 127) {
            throw new IllegalArgumentException(String.format("A maximum of %s values can be transmitted", 127));
        }
        return MeasuredValueShortFloatingPointSequence.createInternal(startAddress, header, new ArrayList<Value<Float>>(values));
    }

    private static MeasuredValueShortFloatingPointSequence createInternal(InformationObjectAddress startAddress, ASDUHeader header, List<Value<Float>> values) {
        return new MeasuredValueShortFloatingPointSequence(header, startAddress, values);
    }
}

