/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.protocol.ngp.codec.impl;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.ae.data.BrowserEntry;
import org.eclipse.scada.ae.protocol.ngp.codec.Structures;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryContext;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryMessageCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowseData
implements BinaryMessageCodec {
    private static final Logger logger = LoggerFactory.getLogger(BrowseData.class);
    public static final int MESSAGE_CODE = 8963;

    public int getMessageCode() {
        return 8963;
    }

    public Class<?> getMessageClass() {
        return org.eclipse.scada.ae.data.message.BrowseData.class;
    }

    public org.eclipse.scada.ae.data.message.BrowseData decodeMessage(BinaryContext _context, IoBuffer _data) throws Exception {
        int messageCode = _data.getInt();
        if (messageCode != 8963) {
            throw new IllegalStateException(String.format("Expected messageCode %s but found %s", 8963, messageCode));
        }
        int numberOfFields = _data.get();
        List<BrowserEntry> addedOrUpdated = null;
        Set removed = null;
        boolean full = false;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    addedOrUpdated = Structures.decodeListBrowserEntry(_context, _data, true);
                    break;
                }
                case 2: {
                    removed = _context.decodeStringSet(_data);
                    break;
                }
                case 3: {
                    full = _context.decodePrimitiveBoolean(_data);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new org.eclipse.scada.ae.data.message.BrowseData(addedOrUpdated, removed, full);
    }

    public IoBuffer encodeMessage(BinaryContext context, Object objectMessage) throws Exception {
        org.eclipse.scada.ae.data.message.BrowseData value = (org.eclipse.scada.ae.data.message.BrowseData)objectMessage;
        IoBuffer data = IoBuffer.allocate((int)64);
        data.setAutoExpand(true);
        data.putInt(8963);
        data.put((byte)3);
        Structures.encodeCollectionBrowserEntry(context, data, (byte)1, value.getAddedOrUpdated());
        context.encodeStringCollection(data, (byte)2, (Collection)value.getRemoved());
        context.encodePrimitiveBoolean(data, (byte)3, value.isFull());
        data.flip();
        return data;
    }
}

