/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.base.extractor.extract;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.base.extractor.extract.ItemDescriptor;
import org.eclipse.scada.base.extractor.extract.ItemValue;
import org.eclipse.scada.base.extractor.input.Data;
import org.eclipse.scada.utils.ExceptionHelper;

public interface Extractor {
    public Result processData(Data var1);

    public static class Result {
        private final Map<ItemDescriptor, ItemValue> itemValues;
        private final Throwable error;

        public Result(Throwable error) {
            this(null, error);
        }

        public Result(Map<ItemDescriptor, ItemValue> itemValues) {
            this.itemValues = itemValues == null ? Collections.emptyMap() : itemValues;
            this.error = null;
        }

        public Result(ItemDescriptor descriptor, ItemValue value) {
            this.itemValues = new HashMap<ItemDescriptor, ItemValue>(1);
            this.itemValues.put(descriptor, value);
            this.error = null;
        }

        public Result(Map<ItemDescriptor, ItemValue> itemValues, Throwable error) {
            this.itemValues = itemValues;
            this.error = error;
        }

        public Map<ItemDescriptor, ItemValue> getItemValues() {
            return this.itemValues;
        }

        public Throwable getError() {
            return this.error;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[Result - ");
            if (this.error != null) {
                sb.append("[Error - ");
                sb.append(ExceptionHelper.extractMessage((Throwable)this.error));
                sb.append("]");
            }
            if (this.itemValues != null) {
                int len = this.itemValues.size();
                for (Map.Entry<ItemDescriptor, ItemValue> entry : this.itemValues.entrySet()) {
                    if (len > 1) {
                        sb.append(System.lineSeparator()).append('\t');
                        sb.append("\t");
                    }
                    sb.append(entry.getKey()).append(" => ").append(entry.getValue());
                }
                if (len > 1) {
                    sb.append(System.lineSeparator());
                }
            }
            if (this.error != null) {
                sb.append(System.lineSeparator());
                sb.append(ExceptionHelper.formatted((Throwable)this.error));
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

