/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.base.extractor.transform;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.eclipse.scada.base.extractor.input.Data;
import org.eclipse.scada.base.extractor.transform.Transformer;

public class StringTransformer
implements Transformer {
    private final Charset charset;

    public StringTransformer(Charset charset) {
        this.charset = charset;
    }

    @Override
    public Data transform(Data data) throws Exception {
        Object value = data.getData();
        if (value == null || value instanceof String) {
            return data;
        }
        try {
            return new Data(this.convert(value), data.getError());
        }
        catch (Exception e) {
            return new Data(null, e);
        }
    }

    protected Object convert(Object value) throws CharacterCodingException {
        if (!(value instanceof byte[])) {
            throw new IllegalArgumentException(String.format("Unable to process data of type: %s. This transformer can only handle byte[]", value.getClass()));
        }
        byte[] data = (byte[])value;
        CharsetDecoder decoder = this.charset.newDecoder();
        CharBuffer result = decoder.decode(ByteBuffer.wrap(data));
        return result.toString();
    }
}

