/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.base.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantEditor;
import org.eclipse.scada.core.VariantType;
import org.eclipse.scada.utils.str.StringHelper;

public class VariantJsonDeserializer
implements JsonDeserializer<Variant> {
    public Variant deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        block27: {
            if (json.isJsonNull()) {
                return null;
            }
            if (json instanceof JsonPrimitive) {
                return this.decodeFromPrimitive(json);
            }
            if (!(json instanceof JsonObject)) break block27;
            JsonObject jsonObj = (JsonObject)json;
            JsonElement type = jsonObj.get("type");
            JsonElement value = jsonObj.get("value");
            if (type == null || type.isJsonNull()) {
                if (value == null) {
                    throw new JsonParseException(String.format("Variant encoded as object must have a field '%s'", "value"));
                }
                return Variant.valueOf((Object)value.getAsString());
            }
            if (!type.isJsonPrimitive()) {
                throw new JsonParseException(String.format("Variant field '%s' must be a string containing the variant type (%s)", "type", StringHelper.join((Object[])VariantType.values(), (String)", ")));
            }
            String typeStr = type.getAsString();
            if (typeStr.equals("NULL")) {
                return Variant.NULL;
            }
            if (value == null || value.isJsonNull()) {
                throw new JsonParseException(String.format("The type '%s' does not support a null value. Use variant type NULL instead.", typeStr));
            }
            if (value.isJsonObject() || value.isJsonArray()) {
                throw new JsonParseException("The variant value must be a JSON primitive matching the type. Arrays and objects are not supported");
            }
            switch (type.getAsString()) {
                case "BOOLEAN": {
                    return Variant.valueOf((boolean)value.getAsBoolean());
                }
                case "STRING": {
                    return Variant.valueOf((Object)value.getAsString());
                }
                case "DOUBLE": {
                    return Variant.valueOf((double)value.getAsDouble());
                }
                case "INT32": {
                    return Variant.valueOf((int)value.getAsInt());
                }
                case "INT64": {
                    return Variant.valueOf((long)value.getAsLong());
                }
            }
            throw new JsonParseException(String.format("Type '%s' is unknown (known types: %s)", StringHelper.join((Object[])VariantType.values(), (String)", ")));
        }
        throw new JsonParseException("Unknown serialization of Variant type");
    }

    private Variant decodeFromPrimitive(JsonElement json) {
        JsonPrimitive jsonPrim = (JsonPrimitive)json;
        if (jsonPrim.isBoolean()) {
            return Variant.valueOf((boolean)jsonPrim.getAsBoolean());
        }
        if (jsonPrim.isNumber()) {
            return Variant.valueOf((Object)jsonPrim.getAsNumber());
        }
        return VariantEditor.toVariant((String)jsonPrim.getAsString());
    }
}

