/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scada.configuration.component.Component;
import org.eclipse.scada.configuration.component.ComponentFactory;
import org.eclipse.scada.configuration.component.InputSpecification;
import org.eclipse.scada.configuration.component.Level;
import org.eclipse.scada.configuration.component.OutputSpecification;
import org.eclipse.scada.configuration.lib.Names;
import org.eclipse.scada.configuration.world.NamedDocumentable;
import org.eclipse.scada.configuration.world.osgi.DataType;
import org.eclipse.scada.utils.str.StringHelper;

public final class Components {
    private static final String delimiter = ".";

    private Components() {
    }

    public static List<String> makeHierarchy(Component component) {
        LinkedList<String> result = new LinkedList<String>();
        Level level = component.getLevel();
        while (level != null) {
            result.add(0, level.getName());
            level = level.getParent();
        }
        return result;
    }

    public static String makeFullQualified(Component component, String ... local) {
        List<String> hier = Components.makeHierarchy(component);
        if (component instanceof NamedDocumentable) {
            hier.add(Names.makeName((NamedDocumentable)((NamedDocumentable)component)));
        }
        hier.addAll(Arrays.asList(local));
        return StringHelper.join(hier, (String)delimiter);
    }

    public static InputSpecification createInput(String string) {
        InputSpecification input = ComponentFactory.eINSTANCE.createInputSpecification();
        input.setName(string);
        return input;
    }

    public static OutputSpecification createOutput(String string, DataType dataType) {
        OutputSpecification output = ComponentFactory.eINSTANCE.createOutputSpecification();
        output.setName(string);
        output.setDataType(dataType);
        return output;
    }
}

