/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.ui.component;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.scada.configuration.world.Documentable;

public class ClassInformationProvider {
    private final Class<? extends Object> classInformation;

    public ClassInformationProvider(Class<?> classInformation) {
        this.classInformation = classInformation;
    }

    public IObservableSet createSuper(Realm realm) {
        WritableSet result = new WritableSet(realm != null ? realm : Realm.getDefault());
        if (this.classInformation != null) {
            this.add(result, this.classInformation.getSuperclass());
            Class<?>[] classArray = this.classInformation.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> iface = classArray[n2];
                this.add(result, iface);
                ++n2;
            }
        }
        return result;
    }

    private void add(WritableSet result, Class<?> clazz) {
        if (clazz == null || clazz.equals(Object.class) || clazz.equals(EObject.class) || clazz.equals(Documentable.class)) {
            return;
        }
        result.add((Object)new ClassInformationProvider(clazz));
    }

    public Class<? extends Object> getClassInformation() {
        return this.classInformation;
    }

    public String getSimpleName() {
        if (this.classInformation == null) {
            return null;
        }
        return this.classInformation.getSimpleName();
    }

    public String getName() {
        if (this.classInformation == null) {
            return null;
        }
        return this.classInformation.getName();
    }

    public String getPackageName() {
        if (this.classInformation != null && this.classInformation.getPackage() != null) {
            return this.classInformation.getPackage().getName();
        }
        return null;
    }
}

