/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.ui.component;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.scada.configuration.ui.component.ClassInformationProvider;
import org.eclipse.scada.configuration.ui.component.Helper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentOutputObservableFactory
implements IObservableFactory {
    private static final Logger logger = LoggerFactory.getLogger(ComponentOutputObservableFactory.class);

    public IObservable createObservable(Object target) {
        logger.debug("Getting observable for: {}", target);
        if (target instanceof IObservableSet) {
            return Observables.proxyObservableSet((IObservableSet)((IObservableSet)target));
        }
        if (target instanceof Helper.Master) {
            return Observables.proxyObservableSet((IObservableSet)((Helper.Master)target).getEntries());
        }
        if (target instanceof Helper.ItemEntry) {
            Helper.ItemEntry itemEntry = (Helper.ItemEntry)target;
            if (itemEntry.getCustomizationRequest() != null && itemEntry.getCustomizationRequest().getComponent() != null) {
                WritableSet result = new WritableSet();
                result.add((Object)new ClassInformationProvider(itemEntry.getCustomizationRequest().getComponent().getClass()));
                return result;
            }
        } else if (target instanceof ClassInformationProvider) {
            return ((ClassInformationProvider)target).createSuper(null);
        }
        return null;
    }
}

