/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.simulation.component.modules;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.browser.common.query.ItemDescriptor;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.DataItemCommand;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.simulation.component.Hive;
import org.eclipse.scada.da.server.simulation.component.modules.ItemAlreadyRegisteredException;

public class BaseModule {
    private Hive hive = null;
    private String base = null;
    private final Map<String, DataItem> items = new HashMap<String, DataItem>();

    public BaseModule(Hive hive, String base) {
        this.hive = hive;
        this.base = base;
    }

    public void dispose() {
        for (DataItem item : this.items.values()) {
            this.hive.unregisterItem(item);
            this.hive.getStorage().removed(new ItemDescriptor(item, new HashMap()));
        }
        this.items.clear();
    }

    protected DataItemInputChained getInput(String name, Map<String, Variant> attributes) {
        String id = this.getItemId(name);
        DataItem dataItem = this.items.get(name);
        if (dataItem != null) {
            if (dataItem instanceof DataItemInputChained) {
                return (DataItemInputChained)dataItem;
            }
            throw new ItemAlreadyRegisteredException(name);
        }
        DataItemInputChained item = new DataItemInputChained(id, this.hive.getOperationService());
        this.items.put(name, (DataItem)item);
        this.hive.registerItem((DataItem)item);
        ItemDescriptor idesc = new ItemDescriptor((DataItem)item, attributes);
        this.hive.getStorage().added(idesc);
        return item;
    }

    protected DataItemCommand getOutput(String name, Map<String, Variant> attributes) {
        String id = this.getItemId(name);
        DataItem dataItem = this.items.get(name);
        if (dataItem != null) {
            if (dataItem instanceof DataItemCommand) {
                return (DataItemCommand)dataItem;
            }
            throw new ItemAlreadyRegisteredException(name);
        }
        DataItemCommand item = new DataItemCommand(id, this.hive.getOperationService());
        this.items.put(name, (DataItem)item);
        this.hive.registerItem((DataItem)item);
        ItemDescriptor idesc = new ItemDescriptor((DataItem)item, attributes);
        this.hive.getStorage().added(idesc);
        return item;
    }

    private String getItemId(String name) {
        return String.valueOf(this.base) + "." + name;
    }
}

