/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.storage.master.hds;

import java.io.File;
import java.nio.file.Files;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.scada.hd.server.storage.hds.AbstractStorageManager;
import org.eclipse.scada.hd.server.storage.hds.StorageConfiguration;
import org.eclipse.scada.hd.server.storage.hds.StorageHelper;
import org.eclipse.scada.hd.server.storage.hds.StorageInformation;
import org.eclipse.scada.hd.server.storage.master.hds.StorageImpl;
import org.eclipse.scada.hds.DataFilePool;
import org.eclipse.scada.utils.concurrent.ScheduledExportedExecutorService;
import org.eclipse.scada.utils.io.RecursiveDeleteVisitor;
import org.eclipse.scada.utils.str.StringReplacer;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageManager
extends AbstractStorageManager {
    static final Logger logger = LoggerFactory.getLogger(StorageManager.class);
    private final BundleContext context;
    private final Map<String, StorageImpl> storages = new HashMap<String, StorageImpl>();
    private final Lock lock = new ReentrantLock();
    private final DataFilePool pool;
    private final ScheduledExecutorService updateExecutor;
    private final ScheduledExecutorService eventExecutor;

    public StorageManager(BundleContext context, DataFilePool pool) {
        super(StorageManager.makeBase(context));
        this.context = context;
        this.pool = pool;
        this.updateExecutor = ScheduledExportedExecutorService.newSingleThreadExportedScheduledExecutor((String)"HDSUpdate");
        this.eventExecutor = ScheduledExportedExecutorService.newSingleThreadExportedScheduledExecutor((String)"org.eclipse.scada.hd.server.storage.master.hds.events");
        this.initialize();
    }

    private static File makeBase(BundleContext context) {
        String basePath = System.getProperty("org.eclipse.scada.hd.server.storage.master.hds.basePath", System.getProperty("org.eclipse.scada.hd.server.storage.hds.basePath"));
        if ((basePath = StringReplacer.replace((String)basePath, (Map)System.getProperties())) == null) {
            File base = context.getDataFile("storage");
            base.mkdir();
            logger.warn("Using local data storage - {}, exists: {}", (Object)base, (Object)base.exists());
            return base;
        }
        File base = new File(basePath);
        base.mkdir();
        logger.warn("Using global data storage - {}, exists: {}", (Object)base, (Object)base.exists());
        return base;
    }

    private void initialize() {
        Map storages = this.findStorages();
        for (Map.Entry entry : storages.entrySet()) {
            try {
                this.loadStorage((File)entry.getValue());
            }
            catch (Exception e) {
                logger.error(String.format("Failed to load storage - id: %s, location: %s", entry.getKey(), entry.getValue()), (Throwable)e);
            }
        }
    }

    public void addStorage(String id, long time, int count) throws Exception {
        File file = this.createStorage(id, time, count);
        if (file != null) {
            this.loadStorage(file);
        }
    }

    private static String makeFileName(String id) {
        StringBuilder sb = new StringBuilder(id.length());
        int i = 0;
        while (i < id.length()) {
            char c = id.charAt(i);
            if (StorageManager.isValidChar(c)) {
                sb.append(c);
            } else {
                sb.append('%');
                sb.append(String.format("%d", c));
            }
            ++i;
        }
        return sb.toString();
    }

    private static boolean isValidChar(char c) {
        if (c >= '0' && c <= '9') {
            return true;
        }
        if (c == '.') {
            return true;
        }
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        return c >= 'A' && c <= 'Z';
    }

    public void removeStorage(File file, boolean force) throws Exception {
        if (!file.isAbsolute()) {
            file = new File(this.base, file.getPath());
        }
        this.lock.lock();
        try {
            if (!file.getParentFile().equals(this.base)) {
                throw new IllegalArgumentException(String.format("'%s' must be a child of the base path '%s'", file, this.base));
            }
            if (!file.isDirectory()) {
                throw new IllegalArgumentException(String.format("'%s' is not a directory", file));
            }
            String id = this.probe(file);
            if (id == null && !force) {
                throw new IllegalArgumentException(String.format("'%s' does not contain a valid storage", file));
            }
            if (id != null) {
                StorageImpl storage = this.storages.remove(id);
                if (storage == null) {
                    logger.warn("Storage in {} ({}) was not registered", (Object)file, (Object)id);
                } else {
                    storage.dispose();
                }
            }
            Files.walkFileTree(file.toPath(), RecursiveDeleteVisitor.INSTANCE);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void purgeAll() {
        this.lock.lock();
        try {
            for (StorageImpl storage : this.storages.values()) {
                storage.purge();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void loadStorage(File file) throws Exception {
        this.lock.lock();
        try {
            StorageImpl storage = new StorageImpl(file, this.context, this.pool, this.queryExecutor, this.updateExecutor, this.eventExecutor);
            this.storages.put(storage.getInformation().getItemId(), storage);
        }
        finally {
            this.lock.unlock();
        }
    }

    private File createStorage(String id, long time, int count) throws Exception {
        this.checkWriteValid();
        File file = new File(this.base, StorageManager.makeFileName(id));
        if (file.exists()) {
            throw new IllegalStateException(String.format("Directory %s already exists. Cannot create new storage!", file));
        }
        StorageConfiguration configuration = this.makeConfiguration(time, count);
        StorageHelper.create((String)id, (File)file, (StorageConfiguration)configuration, (DataFilePool)this.pool);
        return file;
    }

    private StorageConfiguration makeConfiguration(long time, int count) {
        return new StorageConfiguration(time, count);
    }

    protected void checkWriteValid() {
        this.checkValid();
    }

    public void dispose() {
        this.lock.lock();
        try {
            for (StorageImpl storage : this.storages.values()) {
                storage.dispose();
            }
            this.storages.clear();
        }
        finally {
            this.lock.unlock();
        }
        super.dispose();
        this.updateExecutor.shutdown();
        this.eventExecutor.shutdown();
    }

    public Collection<StorageInformation> list() {
        LinkedList<StorageInformation> result = new LinkedList<StorageInformation>();
        this.lock.lock();
        try {
            for (StorageImpl storage : this.storages.values()) {
                result.add(storage.getStorageInformation());
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }
}

