/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateEditor
extends PropertyEditorSupport {
    private final SimpleDateFormat dfDateTimeS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
    private final SimpleDateFormat dfDateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final SimpleDateFormat dfDate = new SimpleDateFormat("yyyy-MM-dd");
    private final SimpleDateFormat dfTimeS = new SimpleDateFormat("HH:mm:ss.S");
    private final SimpleDateFormat dfTime = new SimpleDateFormat("HH:mm:ss");

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        Date d = null;
        if (text == null) {
            this.setValue(null);
            return;
        }
        try {
            if (text.length() == 23) {
                d = this.dfDateTimeS.parse(text);
            } else if (text.length() == 19) {
                d = this.dfDateTime.parse(text);
            } else if (text.length() == 10) {
                d = this.dfDate.parse(text);
            } else if (text.length() == 12) {
                d = this.dfTimeS.parse(text);
            } else if (text.length() == 8) {
                d = this.dfTime.parse(text);
            }
        }
        catch (ParseException parseException) {
            d = null;
        }
        this.setValue(d);
    }

    @Override
    public void setValue(Object value) {
        Date v = null;
        if (value instanceof Date) {
            v = new Date(((Date)value).getTime());
        }
        if (value instanceof Calendar) {
            v = ((Calendar)value).getTime();
        }
        if (value instanceof Integer || value instanceof Long) {
            v = new Date((Long)value);
        }
        super.setValue(v);
    }
}

