/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.viewer.ext.image;

import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.scada.vi.ui.user.viewer.ViewManager;
import org.eclipse.scada.vi.ui.user.viewer.ext.ViewerExtension;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageExtension
implements ViewerExtension,
IExecutableExtension {
    private static final Logger logger = LoggerFactory.getLogger(ImageExtension.class);
    private URL imageUrl;
    private Image image;

    public Control create(Composite composite, ViewManager viewManager, boolean horizontal) {
        Label label = new Label(composite, 0);
        try {
            this.image = new Image((Device)label.getDisplay(), this.imageUrl.openStream());
            label.setImage(this.image);
        }
        catch (IOException e) {
            label.setText("Failed to load image: " + e);
        }
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ImageExtension.this.image != null) {
                    ImageExtension.this.image.dispose();
                }
            }
        });
        return label;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        try {
            if (data instanceof String) {
                this.imageUrl = new URL((String)data);
            }
            if (data instanceof Hashtable) {
                this.imageUrl = new URL((String)((Hashtable)data).get("url"));
            }
        }
        catch (Exception e) {
            logger.warn("Failed to parse URL", (Throwable)e);
        }
    }
}

