/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt.render;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.chart.YAxis;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.Graphics;
import org.eclipse.scada.chart.swt.Helper;
import org.eclipse.scada.chart.swt.render.AbstractRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class YAxisDynamicRenderer
extends AbstractRenderer {
    private YAxis axis;
    private Color color;
    private boolean left;
    private final PropertyChangeListener propertyChangeListener;
    private Rectangle rect;
    private int width = -1;
    protected final LineAttributes lineAttributes;
    private int labelSpacing = 15;
    private final int markerSize = 8;
    private int textPadding = 10;
    private final ChartRenderer chart;
    protected final ResourceManager resourceManager;
    private boolean showLabels = true;
    private String format;

    public YAxisDynamicRenderer(ChartRenderer chart) {
        super(chart);
        this.chart = chart;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)chart.getDisplay()));
        this.color = this.resourceManager.createColor(new RGB(0, 0, 0));
        this.lineAttributes = new LineAttributes(1.0f, 1, 3, 1, new float[0], 0.0f, 0.0f);
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                YAxisDynamicRenderer.this.handlePropertyChange(evt);
            }
        };
    }

    public void setFormat(String format) {
        this.format = format;
        this.redraw();
    }

    public String getFormat() {
        return this.format;
    }

    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
        this.redraw();
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setLabelSpacing(int labelSpacing) {
        this.labelSpacing = labelSpacing;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public void setTextPadding(int textPadding) {
        this.textPadding = textPadding;
    }

    public int getTextPadding() {
        return this.textPadding;
    }

    protected void handlePropertyChange(PropertyChangeEvent evt) {
        this.redraw();
    }

    public void setAlign(int alignment) {
        this.left = (alignment & 0x20000) != 131072;
        this.redraw();
    }

    public void setColor(RGB color) {
        this.color = this.resourceManager.createColor(color);
    }

    public RGB getColor() {
        return this.color.getRGB();
    }

    public void setAxis(YAxis axis) {
        this.checkWidget();
        if (this.axis != null) {
            this.axis.removePropertyChangeListener(this.propertyChangeListener);
            this.axis = null;
        }
        this.axis = axis;
        if (this.axis != null) {
            this.axis.addPropertyChangeListener(this.propertyChangeListener);
            this.redraw();
        }
    }

    @Override
    public void render(Graphics g, Rectangle clientRectangle) {
        String label;
        if (this.rect.width == 0 || this.rect.height == 0) {
            return;
        }
        Rectangle chartRect = this.chart.getClientAreaProxy().getClientRectangle();
        g.setClipping(this.rect);
        g.setLineAttributes(this.lineAttributes);
        g.setForeground(this.color);
        int x = (this.left ? this.rect.width - 1 : 0) + this.rect.x;
        g.drawLine(x, this.rect.y, x, this.rect.y + this.rect.height);
        if (this.showLabels) {
            int fontHeight = g.getFontMetrics().getHeight();
            List<Helper.Entry<Double>> markers = Helper.chartValues(this.axis.getMin(), this.axis.getMax(), chartRect.height, fontHeight + this.labelSpacing);
            for (Helper.Entry<Double> marker : markers) {
                Point labelSize = g.textExtent(marker.label);
                int y = marker.position;
                g.drawText(marker.label, this.left ? x - (labelSize.x + this.textPadding + 8) : x + this.textPadding, y - labelSize.y / 2, null);
                g.drawLine(x, y, x + (this.left ? -1 : 1) * 8, y);
            }
        }
        if ((label = this.axis.getLabel()) != null) {
            Point size = g.textExtent(label);
            g.drawText(label, -this.rect.height + this.rect.height / 2 - size.x / 2, !this.left ? this.rect.width - size.y : 0, Float.valueOf(-90.0f));
        }
        g.setClipping(clientRectangle);
    }

    @Override
    public Rectangle resize(Rectangle clientRectangle) {
        int width;
        int n = width = this.width >= 0 ? this.width : this.calcWidth(clientRectangle.height);
        if (this.left) {
            this.rect = new Rectangle(clientRectangle.x, clientRectangle.y, width, clientRectangle.height);
            return new Rectangle(clientRectangle.x + width, clientRectangle.y, clientRectangle.width - width, clientRectangle.height);
        }
        this.rect = new Rectangle(clientRectangle.x + clientRectangle.width - width, clientRectangle.y, width, clientRectangle.height);
        return new Rectangle(clientRectangle.x, clientRectangle.y, clientRectangle.width - width, clientRectangle.height);
    }

    private int calcWidth(int height) {
        Point axisLabelSize;
        int maxTextWidth = 0;
        if (this.axis == null || this.axis.getMax() - this.axis.getMin() <= 0.0) {
            return 0;
        }
        GC gc = new GC((Drawable)Display.getCurrent());
        try {
            axisLabelSize = this.axis.getLabel() != null && !this.axis.getLabel().isEmpty() ? gc.textExtent(this.axis.getLabel()) : new Point(0, 0);
            if (this.showLabels) {
                int fontHeight = gc.getFontMetrics().getHeight();
                List<Helper.Entry<Double>> markers = Helper.chartValues(this.axis.getMin(), this.axis.getMax(), height, fontHeight + this.labelSpacing);
                for (Helper.Entry<Double> marker : markers) {
                    Point sampleLabelSize = gc.textExtent(marker.label);
                    maxTextWidth = Math.max(maxTextWidth, sampleLabelSize.x);
                }
            }
        }
        finally {
            gc.dispose();
        }
        return maxTextWidth + (this.showLabels ? 2 * this.textPadding + 8 : 0) + axisLabelSize.y + 1;
    }

    @Override
    public void dispose() {
        this.resourceManager.dispose();
        super.dispose();
    }
}

