/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt.render;

import java.util.NavigableSet;
import org.eclipse.scada.chart.DataEntry;
import org.eclipse.scada.chart.SeriesData;
import org.eclipse.scada.chart.XAxis;
import org.eclipse.scada.chart.YAxis;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.DataPoint;
import org.eclipse.scada.chart.swt.Graphics;
import org.eclipse.scada.chart.swt.render.AbstractLineRender;
import org.eclipse.scada.chart.swt.render.Renderer;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepRenderer
extends AbstractLineRender
implements Renderer {
    private static final Logger logger = LoggerFactory.getLogger(StepRenderer.class);

    public StepRenderer(ChartRenderer chartArea, SeriesData abstractSeriesData) {
        super(chartArea, abstractSeriesData);
    }

    @Override
    protected void performRender(Graphics g, Rectangle clientRect) {
        XAxis xAxis = this.seriesData.getXAxis();
        YAxis yAxis = this.seriesData.getYAxis();
        NavigableSet entries = this.seriesData.getViewData().getEntries();
        if (entries.isEmpty()) {
            return;
        }
        Path path = g.createPath();
        try {
            boolean first = true;
            DataPoint point = new DataPoint();
            Float previousY = null;
            logger.trace("Render steps");
            for (DataEntry entry : entries) {
                boolean hasData = StepRenderer.translateToPoint(clientRect, xAxis, yAxis, point, entry);
                logger.trace("Entry - {}, hasData: {}, point: {}", new Object[]{entry, hasData, point});
                if (hasData) {
                    if (first) {
                        first = false;
                        path.moveTo(point.x, point.y);
                    } else {
                        path.lineTo(point.x, previousY.floatValue());
                        path.lineTo(point.x, point.y);
                    }
                    previousY = Float.valueOf(point.y);
                    continue;
                }
                first = true;
                if (previousY == null) continue;
                path.lineTo(point.x, previousY.floatValue());
                previousY = null;
            }
            g.setAlpha(255);
            g.setLineAttributes(this.lineAttributes);
            g.setForeground(this.lineColor != null ? this.lineColor : g.getSystemColor(2));
            g.setClipping(clientRect);
            g.drawPath(path);
        }
        finally {
            path.dispose();
        }
    }
}

